package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;

public class NavigationTestBotParameters extends UDKAgentParameters {

	private String startNavPointId;
	private String endNavPointId;
	private int numOfRepetitions;
	private boolean walkInCircles = false;
        private IPathPlanner<ILocated> pathPlanner = null;
	
	public NavigationTestBotParameters(String startNavPointId, String endNavPointId) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
		numOfRepetitions = 1;
	}

        public NavigationTestBotParameters(String startNavPointId, String endNavPointId,IPathPlanner<ILocated> pathPlanner) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
                this.pathPlanner = pathPlanner;
		numOfRepetitions = 1;
	}
	
	public NavigationTestBotParameters(String startNavPointId, String endNavPointId, int numOfRepetitions) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
		this.numOfRepetitions = numOfRepetitions;
	}
	
	public NavigationTestBotParameters(String startNavPointId, String endNavPointId, int numOfRepetitions,IPathPlanner<ILocated> pathPlanner) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
		this.numOfRepetitions = numOfRepetitions;
                this.pathPlanner = pathPlanner;
	}
        
	public NavigationTestBotParameters(String startNavPointId, String endNavPointId, int numOfRepetitions, boolean walkInCircles) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
		this.numOfRepetitions = numOfRepetitions;
		this.walkInCircles  = walkInCircles;
	}
        
	public NavigationTestBotParameters(String startNavPointId, String endNavPointId, int numOfRepetitions, boolean walkInCircles, IPathPlanner<ILocated> pathPlanner) {
		this.startNavPointId = startNavPointId;
		this.endNavPointId = endNavPointId;
		this.numOfRepetitions = numOfRepetitions;
		this.walkInCircles  = walkInCircles;
                this.pathPlanner = pathPlanner;
	}
        

	public String getStartNavPointId() {
		return startNavPointId;
	}

	public String getEndNavPointId() {
		return endNavPointId;
	}

	public int getNumOfRepetitions() {
		return numOfRepetitions;
	}
	
	public boolean isWalkInCircles() {
		return walkInCircles;
	}

        public IPathPlanner<ILocated> getPathPlanner() {
            return pathPlanner;
        }

        
	
	@Override
	public void assignDefaults(IAgentParameters defaults) {
		super.assignDefaults(defaults);
		if (defaults instanceof NavigationTestBotParameters) {
			if (startNavPointId == null) startNavPointId = ((NavigationTestBotParameters)defaults).getStartNavPointId();
			if (endNavPointId == null) endNavPointId = ((NavigationTestBotParameters)defaults).getEndNavPointId();
                        if (pathPlanner == null) pathPlanner = ((NavigationTestBotParameters)defaults).getPathPlanner();
		}
	}
	
}
