package cz.cuni.amis.pogamut.udk.bot.impl;

import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;

@AgentScoped
public class UDKBotController<BOT extends UDKBot> implements IUDKBotController<BOT> { 

	/**
	 * Name of the log category of the user log.
	 */
    public static final String USER_LOG_CATEGORY_ID = "User";

    /**
     * Instance of the bot we're controlling.
     */
    protected BOT bot;

    /**
     * User log - it's log-level is initially set to {@link Level#ALL}.
     */
    protected LogCategory user = null;

    @Override
    public void initializeController(BOT bot) {
    	this.bot = bot;
        user = bot.getLogger().getCategory(USER_LOG_CATEGORY_ID);
        // sets the logger level, if we would let the logger level to be Level.All the bot would
        // be slowed significantly due to high number of messages
        bot.getLogger().setLevel(Level.WARNING);
        // set user-log to accept every message
        user.setLevel(Level.ALL);
    }
    
    @Override
	public void prepareBot(BOT bot) {		
	}

    public BOT getBot() {
        return bot;
    }

    
    
    @Override
	public PasswordReply getPassword() {
		return new PasswordReply().setPassword("unspecified");
	}
    
    @Override
	public Initialize getInitializeCommand() {
		return new Initialize();
	}
    
    @Override
	public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
	}
    
    @Override
	public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
	}
    
	@Override
	public void botKilled(BotKilled event) {		
	}

	@Override
	public void botShutdown() {
	}
	
	public IVisionWorldView getWorldView() {
		return (IVisionWorldView) bot.getWorldView();
	}
	
	public IAct getAct() {
		return bot.getAct();
	}

    /**
     * Returns user logger. This call is equivalent to <code>bot.getLogger().getCategory(USER_LOG_ID)</code>.
     * @return
     */
    public LogCategory getLog() {
        return user;
    }

}
