package cz.cuni.amis.pogamut.udk.agent.navigation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.BasePathExecutor;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.SetRoute;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.NullCheck;

/**
 * TO BE IMPLEMENTED!!!
 * 
 * TODO: FINISHE THE IMPLEMENTATION
 * 
 * @author Jimmy
 *
 * @param <PATH_ELEMENT>
 */
public class UDKPathExecutorWithPlanner<PATH_ELEMENT extends ILocated> extends BasePathExecutor<PATH_ELEMENT> {

	private IUDKPathNavigator<PATH_ELEMENT> navigator;
	
	private UDKBot bot;
	
	private Self self;
	
	private IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>>() {
		@Override
		public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
			self = event.getObject();
		}
	};
	
	private IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>() {
		@Override
		public void notify(EndMessage event) {
			eventEndMessage();
		}
	};

	public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner) {
		this(bot, pathPlanner, null, null);
	}
	
	public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner, IUDKPathNavigator<PATH_ELEMENT> navigator) {
		this(bot, pathPlanner, navigator, null);
	}
	
	public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner, IUDKPathNavigator<PATH_ELEMENT> navigator, Logger log) {
		super(log);
		if (getLog() == null) {
			setLog(bot.getLogger().getCategory(getClass().getSimpleName()));
		}
		NullCheck.check(bot, "bot");
		this.bot = bot;		
		this.navigator = navigator;
		if (this.navigator == null) {
			this.navigator = new LoqueNavigator<PATH_ELEMENT>(bot, getLog());
		}
		this.navigator.setBot(bot);
		this.navigator.setExecutor(this);
		bot.getWorldView().addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, selfListener);
		bot.getWorldView().addEventListener(EndMessage.class, endMessageListener);
	}
	
	@Override
	protected void stopped() {		
	}
	
	@Override
	protected void followPathImpl() {		
	}
	
	/**
	 * If the path is not zero-length, recalls {@link IUDKPathNavigator#newPath(List)}
	 * and set the path into the GB2004 via {@link SetRoute}.
	 */
	@Override
	protected void pathComputedImpl() {
		if (getPath().size() == 0) {
			targetReached();
		} else {
			bot.getAct().act(new SetRoute().setRoute(getPath()));
			navigator.newPath(getPath());
		}
	}

	@Override
	protected void pathComputationFailedImpl() {
	}
	
	@Override
	protected void stuckImpl() {
		navigator.reset();
	}

	/**
	 * Sets the path into the GB2004 via {@link SetRoute} whenever switch occurs and the rest of the path is greater than
	 * 32 path elements.
	 */
	@Override
	protected void switchToAnotherPathElementImpl() {
		List<PATH_ELEMENT> path = getPath();
		if (path.size() > 31 + getPathElementIndex()) {
			List<PATH_ELEMENT> pathPart = new ArrayList<PATH_ELEMENT>(32);
			for (int i = getPathElementIndex(); i < path.size() && i < getPathElementIndex() + 31; ++i) {
				pathPart.add(path.get(i));
			}
			bot.getAct().act(new SetRoute().setRoute(pathPart));
		}
	}

	@Override
	protected void targetReachedImpl() {
		navigator.reset();
	}
	
	protected void eventEndMessage() {
		if (inState(PathExecutorState.PATH_COMPUTED) || inState(PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT)) {
			navigator.navigate();
		}
	}
	
}
