/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.worldview;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.worldview.UDKWorldView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;

@AgentScoped
public class UDKLockableWorldView
extends UDKWorldView
implements ILockableVisionWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "UDKLockableWorldViewDependency";
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();

    @Inject
    public UDKLockableWorldView(@Named(value="UDKLockableWorldViewDependency") ComponentDependencies dependencies, IMediator mediator, IComponentBus bus, IAgentLogger log) {
        super(dependencies, mediator, bus, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws ComponentNotRunningException {
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view locked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws ComponentNotRunningException {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view is being unlocked.");
            }
            this.locked = false;
            for (List list : this.batches) {
                this.processBatch(list);
            }
            this.batches.clear();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean hasBatchesToProcess() {
        return !this.batches.isEmpty();
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(IWorldChangeEvent event) {
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)this.controller.getState().getFlag(), (Object)this);
        }
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (event instanceof BeginMessage) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (event instanceof EndMessage) {
                    this.currentBatch.add(event);
                    this.batches.add(this.currentBatch);
                    this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 20);
                } else {
                    this.currentBatch.add(event);
                }
            } else if (event instanceof EndMessage) {
                this.currentBatch.add(event);
                this.processBatch(this.currentBatch);
                this.currentBatch.clear();
            } else {
                this.currentBatch.add(event);
            }
        }
    }
}

