/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.bot.impl;

import com.google.inject.Inject;
import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.java.ReflectionObjectFolder;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.jmx.AgentJMXComponents;
import cz.cuni.amis.pogamut.base.agent.jmx.adapter.AgentMBeanAdapter;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.agent.AbstractAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.IUDKBot;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.bot.jmx.BotJMXMBeanAdapter;
import cz.cuni.amis.pogamut.udk.bot.state.impl.BotStateHelloBotReceived;
import cz.cuni.amis.pogamut.udk.bot.state.impl.BotStateInited;
import cz.cuni.amis.pogamut.udk.bot.state.impl.BotStatePassword;
import cz.cuni.amis.pogamut.udk.bot.state.impl.BotStateSendingInit;
import cz.cuni.amis.pogamut.udk.bot.state.impl.BotStateSpawned;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Ready;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.HelloBotHandshake;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.InitCommandRequest;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.ReadyCommandRequest;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutJMXException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

@AgentScoped
public class UDKBot<WORLD_VIEW extends IVisionWorldView, ACT extends IAct, CONTROLLER extends IUDKBotController>
extends AbstractAgent3D<WORLD_VIEW, ACT>
implements IUDKBot {
    private CONTROLLER controller;
    private BusAwareCountDownLatch endMessageLatch;
    private boolean botStoppedCalled = false;
    private EventReact<HelloBotHandshake> helloBotReaction;
    private UDKAgentParameters params;
    private IWorldEventListener<ReadyCommandRequest> readyCommandRequestListener = new IWorldEventListener<ReadyCommandRequest>(){

        public void notify(ReadyCommandRequest event) {
            UDKBot.this.setState(new BotStateHelloBotReceived("GameBots2004 greeted us, adding custom listeners onto the worldview."));
            UDKBot.this.readyCommandRequested();
            UDKBot.this.setState(new BotStateHelloBotReceived("READY sent, handshaking."));
        }
    };
    private IWorldEventListener<InitCommandRequest> initCommandRequestListener = new IWorldEventListener<InitCommandRequest>(){

        public void notify(InitCommandRequest event) {
            UDKBot.this.setState(new BotStateSendingInit("Handshake over, sending INIT."));
            UDKBot.this.initCommandRequested();
            UDKBot.this.setState(new BotStateSendingInit("Handshake over, INIT sent."));
        }
    };
    private IWorldEventListener<Password> passwordRequestedListener = new IWorldEventListener<Password>(){

        public void notify(Password event) {
            UDKBot.this.setState(new BotStatePassword("Password requested by the world."));
            PasswordReply passwordReply = UDKBot.this.getController().getPassword();
            if (passwordReply == null) {
                if (UDKBot.this.log.isLoggable(Level.WARNING)) {
                    UDKBot.this.log.warning("createPasswordReply() returned null");
                }
                passwordReply = new PasswordReply("");
            }
            if (UDKBot.this.log.isLoggable(Level.INFO)) {
                UDKBot.this.log.info("Password required for the world, replying with '" + passwordReply.getPassword() + "'.");
            }
            UDKBot.this.getAct().act((CommandMessage)passwordReply);
            UDKBot.this.setState(new BotStatePassword("Password sent."));
        }
    };
    private IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> initedMessageListener = new IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>>(){

        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            UDKBot.this.setState(new BotStateInited("InitedMessage received, calling botInitialized()."));
            UDKBot.this.controller.botInitialized((GameInfo)UDKBot.this.getWorldView().getSingle(GameInfo.class), (ConfigChange)UDKBot.this.getWorldView().getSingle(ConfigChange.class), (InitedMessage)event.getObject());
            UDKBot.this.setState(new BotStateInited("Bot initialized."));
        }
    };
    private IWorldEventListener<BotKilled> killedListener = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            UDKBot.this.getController().botKilled(event);
        }
    };
    private IWorldEventListener<EndMessage> endListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UDKBot.this.setState(new BotStateSpawned("First batch of informations received - calling botSpawned()."));
            UDKBot.this.controller.botSpawned((GameInfo)UDKBot.this.getWorldView().getSingle(GameInfo.class), (ConfigChange)UDKBot.this.getWorldView().getSingle(ConfigChange.class), (InitedMessage)UDKBot.this.getWorldView().getSingle(InitedMessage.class), (Self)UDKBot.this.getWorldView().getSingle(Self.class));
            UDKBot.this.setState(new BotStateSpawned("botSpawned() finished, UT2004Bot is running."));
            UDKBot.this.getWorldView().removeEventListener(EndMessage.class, (IWorldEventListener)this);
            UDKBot.this.endMessageLatch.countDown();
        }
    };

    @Inject
    public UDKBot(UDKAgentParameters parameters, IComponentBus eventBus, IAgentLogger logger, IWorldView worldView, IAct act, IUDKBotController init) {
        super(parameters.getAgentId(), eventBus, logger, (IVisionWorldView)worldView, act);
        this.params = parameters;
        this.controller = init;
        NullCheck.check(this.controller, (String)"init");
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Initializing the controller...");
        }
        this.controller.initializeController((UDKBot)this);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Preparing the controller...");
        }
        this.controller.prepareBot((UDKBot)this);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Controller initialized.");
        }
        this.helloBotReaction = new EventReact<HelloBotHandshake>(HelloBotHandshake.class, worldView){

            protected void react(HelloBotHandshake event) {
                if (event.isServerFull()) {
                    throw new ComponentCantStartException("Server is full.", (IComponent)UDKBot.this);
                }
            }
        };
        this.getWorldView().addEventListener(ReadyCommandRequest.class, this.readyCommandRequestListener);
        this.getWorldView().addEventListener(InitCommandRequest.class, this.initCommandRequestListener);
        this.getWorldView().addEventListener(Password.class, this.passwordRequestedListener);
        this.getWorldView().addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this.initedMessageListener);
        this.getWorldView().addEventListener(BotKilled.class, this.killedListener);
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{this.getWorldView()});
    }

    public CONTROLLER getController() {
        return this.controller;
    }

    public UDKAgentParameters getParams() {
        return this.params;
    }

    protected void startAgent() {
        this.botStoppedCalled = false;
        super.startAgent();
        this.getWorldView().addEventListener(EndMessage.class, this.endListener);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Waiting for the handshake to finish for 60s.");
        }
        if (!this.endMessageLatch.await(60000L, TimeUnit.MILLISECONDS)) {
            throw new ComponentCantStartException("The bot did not received first EndMessage in 60 seconds.", (IComponent)this);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Handshake finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAgent() {
        try {
            if (!this.botStoppedCalled) {
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
        }
        finally {
            super.stopAgent();
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{this.getWorldView()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAgent() {
        try {
            if (!this.botStoppedCalled) {
                this.botStoppedCalled = true;
                this.controller.botShutdown();
            }
        }
        finally {
            super.killAgent();
        }
        this.endMessageLatch = new BusAwareCountDownLatch(1, this.getEventBus(), new IComponent[]{this.getWorldView()});
    }

    protected void readyCommandRequested() {
        this.getAct().act((CommandMessage)new Ready());
    }

    protected void initCommandRequested() {
        Initialize initializeCommand = this.getController().getInitializeCommand();
        if (initializeCommand == null) {
            throw new AgentException("getBotInit().getInitializeCommand() method returned null message, can't initialize the agent!", (Logger)this.log, (Object)this);
        }
        if (initializeCommand.getName() == null) {
            initializeCommand.setName((String)this.getComponentId().getName().getFlag());
        } else {
            this.getComponentId().getName().setFlag((Object)initializeCommand.getName());
        }
        try {
            initializeCommand.setJmx(this.getJMX().enableJMX());
        }
        catch (Exception e) {
            throw new PogamutJMXException("Error seting up JMX name of the agent.", (Throwable)e, (Logger)this.log, (Object)this);
        }
        this.getAct().act((CommandMessage)initializeCommand);
    }

    public Location getLocation() {
        Self self = (Self)this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getLocation();
        }
        return null;
    }

    public Rotation getRotation() {
        Self self = (Self)this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getRotation();
        }
        return null;
    }

    public Velocity getVelocity() {
        Self self = (Self)this.getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getVelocity();
        }
        return null;
    }

    public void respawn() throws PogamutException {
        this.getAct().act((CommandMessage)new Respawn());
    }

    protected AgentJMXComponents createAgentJMX() {
        return new AgentJMXComponents<IUDKBot>((IUDKBot)this){

            protected AgentMBeanAdapter createAgentMBean(ObjectName objectName, MBeanServer mbs) throws MalformedObjectNameException, InstanceAlreadyExistsException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                return new BotJMXMBeanAdapter<UDKBot>(UDKBot.this, objectName, mbs);
            }
        };
    }

    @Override
    public void setBoolConfigure(IUDKBot.BoolBotParam param, boolean value) {
        try {
            Configuration configuration = new Configuration();
            ConfigChange confCh = (ConfigChange)this.getWorldView().getSingle(ConfigChange.class);
            configuration.copy(confCh);
            param.set((Object)configuration, value);
            param.setField(confCh, value);
            this.getAct().act((CommandMessage)configuration);
        }
        catch (Exception ex) {
            Logger.getLogger(UDKBot.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean getBoolConfigure(IUDKBot.BoolBotParam param) {
        try {
            return param.get((ConfigChange)this.getWorldView().getSingle(ConfigChange.class));
        }
        catch (Exception ex) {
            Logger.getLogger(UDKBot.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    protected Folder createIntrospection() {
        return new ReflectionObjectFolder("root", this.controller);
    }

    public WORLD_VIEW getWorldView() {
        return (WORLD_VIEW)((IVisionWorldView)super.getWorldView());
    }
}

