/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.UDKBotTestController;
import cz.cuni.amis.pogamut.udk.agent.navigation.NavigationTestBotParameters;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import java.util.logging.Level;

public class NavigationTestBot
extends UDKBotTestController<UDKBot> {
    State state = State.INIT;
    NavPoint startNavPoint = null;
    NavPoint endNavPoint = null;
    UnrealId startNavPointId = null;
    UnrealId endNavPointId = null;
    Integer totalRepetitions = null;
    int repetitions = 0;
    boolean walkInCircles = false;
    String name;

    public void prepareBot(UDKBot bot) {
        if (bot.getParams() instanceof NavigationTestBotParameters) {
            NavigationTestBotParameters navigationParams = (NavigationTestBotParameters)bot.getParams();
            if (this.startNavPointId == null) {
                this.setStartNavPointId(navigationParams.getStartNavPointId());
            }
            if (this.endNavPointId == null) {
                this.setEndNavPointId(navigationParams.getEndNavPointId());
            }
            if (this.totalRepetitions == null) {
                this.totalRepetitions = navigationParams.getNumOfRepetitions();
            }
            if (navigationParams.getPathPlanner() != null) {
                this.pathPlanner = navigationParams.getPathPlanner();
            }
            this.walkInCircles = navigationParams.isWalkInCircles();
        }
    }

    protected void initializePathFinding(UDKBot bot) {
        super.initializePathFinding(bot);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.pathExecutor.getLog().setLevel(Level.ALL);
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        this.name = self.getName();
    }

    public Initialize getInitializeCommand() {
        this.startNavPoint = (NavPoint)this.getWorldView().get((WorldObjectId)this.startNavPointId, NavPoint.class);
        if (this.startNavPoint == null) {
            throw new IllegalStateException("Could not find start NavPoint: " + this.startNavPointId);
        }
        return new Initialize().setLocation(this.startNavPoint.getLocation());
    }

    public void logic() {
        if (this.isFailure()) {
            this.getLog().severe("FAILED");
            return;
        }
        if (this.isSuccess()) {
            this.getLog().severe("SUCCEEDED");
            return;
        }
        switch (this.state) {
            case INIT: {
                if (this.startNavPointId == null) {
                    this.setFailure("startNavPointId not set!");
                    return;
                }
                if (this.endNavPointId == null) {
                    this.setFailure("endNavPointId not set!");
                }
                this.startNavPoint = (NavPoint)this.world.getAll(NavPoint.class).get(this.startNavPointId);
                if (this.startNavPoint == null) {
                    this.setFailure("Could not find start navpoint '" + this.startNavPointId.getStringId() + "'!");
                    return;
                }
                this.endNavPoint = (NavPoint)this.world.getAll(NavPoint.class).get(this.endNavPointId);
                if (this.endNavPoint == null) {
                    this.setFailure("Could not find end navpoint '" + this.endNavPointId.getStringId() + "'!");
                    return;
                }
                if (this.totalRepetitions == null) {
                    this.setFailure("Number of repetitions for the test was not set!");
                    return;
                }
                this.repetitions = this.totalRepetitions;
                if (this.repetitions <= 0) {
                    this.setFailure("Number of repetitions for the test <= 0!");
                    return;
                }
                this.state = State.PREPARE_TEST;
                return;
            }
            case PREPARE_TEST: {
                this.state = State.SPAWNED;
                return;
            }
            case SPAWNED: {
                if (!this.info.atLocation(this.startNavPoint.getLocation())) {
                    this.getLog().warning("Bot is not at " + this.startNavPoint.getId().getStringId() + ", respawning again!");
                    this.body.getAction().respawn((ILocated)this.startNavPoint);
                    return;
                }
                this.getLog().warning("Navigation test " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.config.setName(this.name + " " + (this.totalRepetitions - this.repetitions + 1) + " / " + this.totalRepetitions);
                this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)this.endNavPoint));
                this.state = State.COMMAND_ISSUED;
                return;
            }
            case COMMAND_ISSUED: {
                if (this.pathExecutor.isExecuting()) {
                    return;
                }
                if (this.info.atLocation(this.endNavPoint.getLocation())) {
                    if (this.walkInCircles) {
                        this.pathExecutor.followPath(this.pathPlanner.computePath((Object)this.info.getLocation(), (Object)this.startNavPoint));
                        this.state = State.RUNNING_BACK;
                        return;
                    }
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                    } else {
                        this.getLog().info("Successfully arrived to '" + this.endNavPointId.getStringId() + "'.");
                        this.state = State.PREPARE_TEST;
                    }
                    return;
                }
                this.setFailure("Failed to arrive to '" + this.endNavPointId.getStringId() + "'.");
                return;
            }
            case RUNNING_BACK: {
                if (this.pathExecutor.isExecuting()) {
                    return;
                }
                if (this.info.atLocation(this.startNavPoint.getLocation())) {
                    --this.repetitions;
                    if (this.repetitions == 0) {
                        this.setSuccess("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                    } else {
                        this.getLog().info("Successfully arrived back to '" + this.startNavPointId.getStringId() + "'.");
                        this.state = State.SPAWNED;
                    }
                    return;
                }
                this.setFailure("Failed to arrive back at '" + this.startNavPointId.getStringId() + "'.");
                return;
            }
        }
    }

    public UnrealId getStartNavPointId() {
        return this.startNavPointId;
    }

    public void setStartNavPointId(String startNavPointId) {
        this.startNavPointId = UnrealId.get((String)startNavPointId);
    }

    public UnrealId getEndNavPointId() {
        return this.endNavPointId;
    }

    public void setEndNavPointId(String endNavpointId) {
        this.endNavPointId = UnrealId.get((String)endNavpointId);
    }

    public void setStartNavPointId(UnrealId startNavPointId) {
        this.startNavPointId = startNavPointId;
    }

    public void setEndNavPointId(UnrealId endNavpointId) {
        this.endNavPointId = endNavpointId;
    }

    public int getRepetitions() {
        return this.totalRepetitions == null ? 0 : this.totalRepetitions;
    }

    public void setRepetitions(int repetitions) {
        this.totalRepetitions = repetitions;
    }

    private static enum State {
        INIT,
        PREPARE_TEST,
        SPAWNED,
        COMMAND_ISSUED,
        RUNNING_BACK;

    }
}

