package cz.cuni.amis.pogamut.udk.server;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

import cz.cuni.amis.pogamut.udk.bot.IUDKBot;
import cz.cuni.amis.pogamut.udk.bot.impl.NativeUDKBotAdapter;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.udk.communication.worldview.map.UDKMap;
import cz.cuni.amis.pogamut.udk.server.exception.MapChangeException;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.flag.Flag;

// TODO: [Ruda] specify the UT2004 server interface
public interface IUDKServer extends IUnrealServer<IUDKBot> {
    
	/**
	 * Sets the address of the server to different location - does not automatically reconnect,
	 * use {@link IUDKServer#stop()} and {@link IUDKServer#start()}.
	 * @param address
	 */
	public void setAddress(String host, int port);
	
    /**
     * @return List of all maps available on the UT server
     */
    public Collection<MapList> getAvailableMaps();
  
// GameInfo doesn't exist anymore, JSimlo changed it into something else
//    public GameInfo getGameInfo();
    
    /**
     * The flag raises events even when the game speed was changed by another 
     * UTServer instance or directly in game.
     * @return Speed of the game.
     */
    public Flag<Double> getGameSpeedFlag();
    
    /** 
     * @return Name of the current map.
     */
    public String getMapName();
    
    /**
     * Method that initiates map-change. It returns future that describes the result.
     * <p><p>
     * Note that the object must restart itself in order to reconnect to the new server. 
     * 
     * @param map
     */
    public Future<Boolean> setGameMap(String map) throws MapChangeException;
    
    /**
     * Returns list of all players connected to the game server. The difference 
     * compared to the getAgents() method is that this method can return even the
     * native bots, human players etc. 
     * @return List of all players on the server.
     */
    public ObservableCollection<Player> getPlayers();

    /**
     * Returns list of all non pogamut players connected to the game server. Collection
     * contains NativeBotAdapter classes, this means that you can deal with the
     * players like with Pogamut agents.
     * @
     * @return List of all players on the server.
     */
    public ObservableCollection<? extends NativeUDKBotAdapter> getNativeAgents();

    /**
     * Reeturns list of all mutators available on the server. Mutators can be 
     * used to modify the game (eg. disable weapons, change game speed).
     * @return List of all mutators available on the server.
     */
    public List<Mutator> getMutators();

    /**
     * Connects a UT native bot to the current map.
     * @param botName
     */
    public void connectNativeBot(String botName, String botType);

    /**
     * Get current map from the server
     * @return Map of current level.
     */
    public UDKMap getMap();

}