package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;


import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.ObjectInstanceEventWrapper;

public class ObjectInstanceEventWrapperConverter extends ObjectEventWrapperConverter {
		
	public ObjectInstanceEventWrapperConverter(WorldViewTestContext ctx) {
		super(ctx);
	}
	
	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {
		
		ObjectInstanceEventWrapper<?> wrapper = (ObjectInstanceEventWrapper<?>)value;
				
		super.marshal(value, writer, context);
		
		writer.startNode("Id");
		context.convertAnother(wrapper.getId().getStringId());
		writer.endNode();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		
		DeserializedWrapperData dataForWrapper =
			(DeserializedWrapperData)super.unmarshal(reader, context);
		
		reader.moveDown();
		String string_id = (String)context.convertAnother(dataForWrapper, String.class);
		reader.moveUp();
		UnrealId id = UnrealId.get(string_id);
		ObjectInstanceEventWrapper<?> wrapper =
			new ObjectInstanceEventWrapper<IWorldObject>(
					ctx,
					(IWorldObjectEvent<IWorldObject>) dataForWrapper.expectedEvent,
					id,
					dataForWrapper.level);
		
		return wrapper;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return clazz == ObjectInstanceEventWrapper.class;
	}

}
