/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.utils;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.AgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.IUDKBot;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;

public class UDKBotRunner<BOT extends IUDKBot, PARAMS extends UDKAgentParameters>
extends AgentRunner<BOT, PARAMS> {
    protected String host;
    protected int port;
    protected String name;

    public UDKBotRunner(IAgentFactory<BOT, PARAMS> factory, String name, String host, int port) {
        super(factory);
        this.name = name;
        this.port = port;
        this.host = host;
    }

    public UDKBotRunner(IAgentFactory<BOT, PARAMS> factory, String name) {
        this(factory, name, Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_PORT.getKey()));
    }

    public UDKBotRunner(IAgentFactory<BOT, PARAMS> factory) {
        this(factory, "UDKBot");
    }

    public UDKBotRunner(UDKBotModule module, String name, String host, int port) {
        this((IAgentFactory<BOT, PARAMS>)new UDKBotFactory(module), name, host, port);
    }

    public UDKBotRunner(UDKBotModule module, String name) {
        this(module, name, Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_PORT.getKey()));
    }

    public UDKBotRunner(UDKBotModule module) {
        this(module, "UDKBot");
    }

    public UDKBotRunner(Class<? extends IUDKBotController> botControllerClass, String name, String host, int port) {
        this(new UDKBotModule(botControllerClass), name, host, port);
    }

    public UDKBotRunner(Class<? extends IUDKBotController> botControllerClass, String name) {
        this(new UDKBotModule(botControllerClass), name, Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_PORT.getKey()));
    }

    public UDKBotRunner(Class<? extends IUDKBotController> botControllerClass) {
        this(new UDKBotModule(botControllerClass), "UDKBot");
    }

    public BOT startAgent() throws PogamutException {
        return (BOT)((IUDKBot)super.startAgent());
    }

    public List<BOT> startAgents(int count) throws PogamutException {
        return super.startAgents(count);
    }

    public List<BOT> startAgents(PARAMS ... agentParameters) throws PogamutException {
        return super.startAgents(agentParameters);
    }

    public String getName() {
        return this.name;
    }

    public UDKBotRunner<BOT, PARAMS> setName(String name) {
        if (name == null) {
            name = "UDKBot";
        }
        this.name = name;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UDKBotRunner<BOT, PARAMS> setHost(String host) {
        this.host = host;
        NullCheck.check((Object)this.host, (String)"host");
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UDKBotRunner<BOT, PARAMS> setPort(int port) {
        this.port = port;
        return this;
    }

    protected IAgentParameters newDefaultAgentParameters() {
        return new UDKAgentParameters().setAgentId((IAgentId)new AgentId(this.name)).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(this.host, this.port));
    }
}

