/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation.stuckdetector;

import cz.cuni.amis.pogamut.base.agent.navigation.IStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UDKPositionHistoryStuckDetector
implements IStuckDetector {
    private static double DEFAULT_MIN_DIAMETER = 70.0;
    private static double DEFAULT_MIN_Z = 100.0;
    private static int DEFAULT_HISTORY_LENGTH = 4;
    private UDKBot bot;
    private double minMovementDiameter;
    private int historyLength;
    private List<Location> locationHistory;
    private boolean stuck = false;
    private SelfListener selfListener;
    private Logger log;
    private double minMovementZ;

    public void setBotWaiting(boolean state) {
    }

    public UDKPositionHistoryStuckDetector(UDKBot bot) {
        this(bot, DEFAULT_HISTORY_LENGTH, DEFAULT_MIN_DIAMETER, DEFAULT_MIN_Z);
    }

    public UDKPositionHistoryStuckDetector(UDKBot bot, int historyLength, double minMovementDiameter, double minMovementZ) {
        if (this.log == null) {
            this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        }
        this.bot = bot;
        this.selfListener = new SelfListener((IWorldView)bot.getWorldView());
        this.historyLength = historyLength;
        if (this.historyLength < 0) {
            throw new IllegalArgumentException("historyLenght can't be < 0");
        }
        this.minMovementDiameter = minMovementDiameter;
        this.minMovementZ = minMovementZ;
        this.locationHistory = new ArrayList<Location>(this.historyLength);
    }

    public void eventSelf(IWorldObjectEvent<Self> event) {
        this.locationHistory.add(((Self)event.getObject()).getLocation());
        while (this.locationHistory.size() > this.historyLength) {
            this.locationHistory.remove(0);
        }
        if (this.locationHistory.size() == this.historyLength) {
            double maxDistance = Double.NEGATIVE_INFINITY;
            double maxHeight = Double.NEGATIVE_INFINITY;
            for (Location loc1 : this.locationHistory) {
                for (Location loc2 : this.locationHistory) {
                    if (maxDistance < loc1.getDistance2D(loc2)) {
                        maxDistance = loc1.getDistance2D(loc2);
                    }
                    if (!(Math.abs(loc1.z - loc2.z) > maxHeight)) continue;
                    maxHeight = Math.abs(loc1.z - loc2.z);
                }
            }
            this.stuck = maxDistance < this.minMovementDiameter && maxHeight < this.minMovementZ;
        }
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void reset() {
        this.locationHistory.clear();
        this.stuck = false;
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }

        public void notify(IWorldObjectEvent<Self> event) {
            UDKPositionHistoryStuckDetector.this.eventSelf(event);
        }
    }
}

