/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.PlayerLeft;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Players
extends SensorModule<UDKBot> {
    private PlayerMaps players = new PlayerMaps();
    private PlayerMaps enemies = new PlayerMaps();
    private PlayerMaps friends = new PlayerMaps();
    PlayerListener playerListener = new PlayerListener(this.worldView);
    PlayerLeftListener playerLeftListener = new PlayerLeftListener(this.worldView);
    SelfListener selfListener = new SelfListener(this.worldView);
    Self lastSelf = null;

    public Player getPlayer(UnrealId UnrealId2) {
        return (Player)this.players.all.get(UnrealId2);
    }

    public Player getVisiblePlayer(UnrealId UnrealId2) {
        return (Player)this.players.visible.get(UnrealId2);
    }

    public Player getReachablePlayer(UnrealId UnrealId2) {
        return (Player)this.players.reachable.get(UnrealId2);
    }

    public Map<UnrealId, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players.all);
    }

    public Map<UnrealId, Player> getEnemies() {
        return Collections.unmodifiableMap(this.enemies.all);
    }

    public Map<UnrealId, Player> getFriends() {
        return Collections.unmodifiableMap(this.friends.all);
    }

    public Map<UnrealId, Player> getVisiblePlayers() {
        return Collections.unmodifiableMap(this.players.visible);
    }

    public Map<UnrealId, Player> getVisibleEnemies() {
        return Collections.unmodifiableMap(this.enemies.visible);
    }

    public Map<UnrealId, Player> getVisibleFriends() {
        return Collections.unmodifiableMap(this.friends.visible);
    }

    public Map<UnrealId, Player> getReachablePlayers() {
        return Collections.unmodifiableMap(this.players.reachable);
    }

    public Map<UnrealId, Player> getReachableEnemies() {
        return Collections.unmodifiableMap(this.enemies.reachable);
    }

    public Map<UnrealId, Player> getReachableFriends() {
        return Collections.unmodifiableMap(this.friends.reachable);
    }

    public Player getNearestPlayer(double recently) {
        Player nearest = null;
        double distance = Double.MAX_VALUE;
        for (Player plr : this.players.all.values()) {
            double d;
            if (!plr.isVisible() && !(this.lastSelf.getLastSeenTime() - plr.getLastSeenTime() <= recently) || !((d = this.lastSelf.getLocation().getDistance(plr.getLocation())) < distance)) continue;
            distance = d;
            nearest = plr;
        }
        return nearest;
    }

    public Player getNearestEnemy(double recentlyVisibleTime) {
        Player nearest = null;
        double distance = Double.MAX_VALUE;
        for (Player plr : this.enemies.all.values()) {
            double d;
            if (!plr.isVisible() && !(this.lastSelf.getLastSeenTime() - plr.getLastSeenTime() <= recentlyVisibleTime) || !((d = this.lastSelf.getLocation().getDistance(plr.getLocation())) < distance)) continue;
            distance = d;
            nearest = plr;
        }
        return nearest;
    }

    public Player getNearestFriend(double recentlyVisibleTime) {
        Player nearest = null;
        double distance = Double.MAX_VALUE;
        for (Player plr : this.friends.all.values()) {
            double d;
            if (!plr.isVisible() && !(this.lastSelf.getLastSeenTime() - plr.getLastSeenTime() <= recentlyVisibleTime) || !((d = this.lastSelf.getLocation().getDistance(plr.getLocation())) < distance)) continue;
            distance = d;
            nearest = plr;
        }
        return nearest;
    }

    public Player getNearestVisiblePlayer() {
        return (Player)DistanceUtils.getNearest(this.players.visible.values(), (ILocated)this.lastSelf.getLocation());
    }

    public Player getNearestVisibleEnemy() {
        return (Player)DistanceUtils.getNearest(this.enemies.visible.values(), (ILocated)this.lastSelf.getLocation());
    }

    public Player getNearestVisibleFriend() {
        return (Player)DistanceUtils.getNearest(this.friends.visible.values(), (ILocated)this.lastSelf.getLocation());
    }

    public Player getNearestVisiblePlayer(Collection<Player> players) {
        return (Player)DistanceUtils.getNearestVisible(players, (ILocated)this.lastSelf.getLocation());
    }

    public Player getRandomVisiblePlayer() {
        return (Player)MyCollections.getRandom(this.players.visible.values());
    }

    public Player getRandomVisibleEnemy() {
        return (Player)MyCollections.getRandom(this.enemies.visible.values());
    }

    public Player getRandomVisibleFriend() {
        return (Player)MyCollections.getRandom(this.friends.visible.values());
    }

    public boolean canSeePlayers() {
        return this.players.visible.size() > 0;
    }

    public boolean canSeeEnemies() {
        return this.enemies.visible.size() > 0;
    }

    public boolean canSeeFriends() {
        return this.friends.visible.size() > 0;
    }

    public boolean canReachPlayers() {
        return this.players.reachable.size() > 0;
    }

    public boolean canReachEnemies() {
        return this.enemies.reachable.size() > 0;
    }

    public boolean canReachFriends() {
        return this.friends.reachable.size() > 0;
    }

    public boolean isEnemy(int team) {
        return team == 255 || team != this.lastSelf.getTeam();
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy(player.getTeam());
    }

    public boolean isFriend(int team) {
        return team != 255 && team == this.lastSelf.getTeam();
    }

    public boolean isFriend(Player player) {
        return this.isFriend(player.getTeam());
    }

    public Players(UDKBot bot) {
        this(bot, null);
    }

    public Players(UDKBot bot, Logger log) {
        super((IObservingAgent)bot, log);
    }

    protected void start(boolean startPaused) {
        super.start(startPaused);
        this.lastSelf = null;
        this.players.clear();
        this.friends.clear();
        this.enemies.clear();
    }

    private class SelfListener
    implements IWorldObjectListener<Self> {
        public void notify(IWorldObjectEvent<Self> event) {
            if (Players.this.lastSelf == null) {
                Players.this.lastSelf = (Self)event.getObject();
                for (Player plr : Players.this.players.all.values()) {
                    if (Players.this.isFriend(plr)) {
                        Players.this.friends.notify(plr);
                    }
                    if (!Players.this.isEnemy(plr)) continue;
                    Players.this.enemies.notify(plr);
                }
            } else {
                Players.this.lastSelf = (Self)event.getObject();
            }
        }

        public SelfListener(IWorldView worldView) {
            worldView.addObjectListener(Self.class, (IWorldObjectEventListener)this);
        }
    }

    private class PlayerLeftListener
    implements IWorldEventListener<PlayerLeft> {
        public void notify(PlayerLeft event) {
            UnrealId uid = event.getId();
            Players.this.players.remove(uid);
            Players.this.enemies.remove(uid);
            Players.this.friends.remove(uid);
        }

        public PlayerLeftListener(IWorldView worldView) {
            worldView.addEventListener(PlayerLeft.class, (IWorldEventListener)this);
        }
    }

    private class PlayerListener
    implements IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> {
        public void notify(WorldObjectUpdatedEvent<Player> event) {
            Player player = (Player)event.getObject();
            Players.this.players.notify(player);
            if (Players.this.lastSelf == null) {
                return;
            }
            if (Players.this.isEnemy(player)) {
                Players.this.enemies.notify(player);
            }
            if (Players.this.isFriend(player)) {
                Players.this.friends.notify(player);
            }
        }

        public PlayerListener(IWorldView worldView) {
            worldView.addObjectListener(Player.class, WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)this);
        }
    }

    private class PlayerMaps {
        private HashMap<UnrealId, Player> all = new HashMap();
        private HashMap<UnrealId, Player> visible = new HashMap();
        private HashMap<UnrealId, Player> reachable = new HashMap();

        private PlayerMaps() {
        }

        private void notify(Player player) {
            UnrealId uid = player.getId();
            if (!this.all.containsKey(uid)) {
                this.all.put(uid, player);
            }
            boolean wasVisible = this.visible.containsKey(uid);
            boolean isVisible = player.isVisible();
            if (isVisible && !wasVisible) {
                this.visible.put(uid, player);
            } else if (!isVisible && wasVisible) {
                this.visible.remove(uid);
            }
            boolean wasReachable = this.reachable.containsKey(uid);
            boolean isReachable = player.isReachable();
            if (isReachable && !wasReachable) {
                this.reachable.put(uid, player);
            } else if (!isReachable && wasReachable) {
                this.reachable.remove(uid);
            }
        }

        private void remove(UnrealId uid) {
            this.all.remove(uid);
            this.visible.remove(uid);
            this.reachable.remove(uid);
        }

        private void clear() {
            this.all.clear();
            this.visible.clear();
            this.reachable.clear();
        }
    }
}

