/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.storyworld.place;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.udk.storyworld.perception.SPLocation;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Point3d;

@XStreamAlias(value="place")
public class SPStoryPlace {
    @XStreamOmitField
    private static Random random = new Random(System.currentTimeMillis());
    @XStreamOmitField
    private SPStoryPlace insidePlace = null;
    @XStreamAlias(value="inside")
    @XStreamAsAttribute
    protected String insidePlaceName;
    @XStreamOmitField
    private Set<SPStoryPlace> higherPlaces = null;
    @XStreamOmitField
    private Set<SPStoryPlace> containsPlaces = new HashSet<SPStoryPlace>();
    @XStreamOmitField
    private Set<SPStoryPlace> containsAllPlaces = null;
    @XStreamOmitField
    private Set<NavPoint> virtualPlaces = null;
    @XStreamOmitField
    private SPLocation center = null;
    @XStreamOmitField
    private NavPoint centerNavPoint = null;
    @XStreamAlias(value="name")
    @XStreamAsAttribute
    private String nameString;
    @XStreamOmitField
    private Token name = null;
    @XStreamOmitField
    private List<NavPoint> navPointsList = null;

    public SPStoryPlace(String name, SPStoryPlace inside) {
        this.nameString = name;
        this.name = Tokens.get((String)name);
        this.setInsidePlace(inside);
    }

    public SPStoryPlace(String name) {
        this.nameString = name;
        this.name = Tokens.get((String)name);
    }

    private SPStoryPlace readResolve() {
        this.insidePlace = null;
        this.higherPlaces = null;
        this.containsPlaces = new HashSet<SPStoryPlace>();
        this.containsAllPlaces = null;
        this.virtualPlaces = null;
        this.name = null;
        this.getName();
        return this;
    }

    protected void setInsidePlace(SPStoryPlace place) {
        if (this.insidePlace != null) {
            throw new RuntimeException("insidePlace already set for the " + this);
        }
        this.insidePlace = place;
        if (this.insidePlace != null) {
            this.insidePlaceName = place.getName().getToken();
            this.insidePlace.getContainsPlaces().add(this);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SPStoryPlace)) {
            return false;
        }
        SPStoryPlace place = (SPStoryPlace)obj;
        return this.name.equals((Object)place.getName());
    }

    public Token getName() {
        if (this.name == null) {
            this.name = Tokens.get((String)this.nameString);
        }
        return this.name;
    }

    public SPStoryPlace getInsidePlace() {
        return this.insidePlace;
    }

    public String getInsidePlaceName() {
        return this.insidePlaceName;
    }

    public Set<SPStoryPlace> getHigherPlaces() {
        if (this.higherPlaces == null) {
            this.higherPlaces = new HashSet<SPStoryPlace>();
            for (SPStoryPlace current = this.insidePlace; current != null; current = current.getInsidePlace()) {
                this.higherPlaces.add(current);
            }
        }
        return this.higherPlaces;
    }

    public Set<SPStoryPlace> getContainsPlaces() {
        return this.containsPlaces;
    }

    public Set<SPStoryPlace> getContainsAllPlaces() {
        if (this.containsAllPlaces == null) {
            this.containsAllPlaces = new HashSet<SPStoryPlace>();
            for (SPStoryPlace place : this.containsPlaces) {
                this.containsAllPlaces.addAll(place.getContainsAllPlaces());
            }
        }
        return this.containsAllPlaces;
    }

    public Set<NavPoint> getNavPoints() {
        if (this.virtualPlaces == null) {
            this.virtualPlaces = new HashSet<NavPoint>();
            for (SPStoryPlace place : this.getContainsPlaces()) {
                this.virtualPlaces.addAll(place.getNavPoints());
            }
        }
        return this.virtualPlaces;
    }

    public List<NavPoint> getNavPointsList() {
        if (this.navPointsList == null) {
            this.navPointsList = MyCollections.asList(this.getNavPoints());
        }
        return this.navPointsList;
    }

    public SPLocation getCenter() {
        if (this.center == null) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (NavPoint navPoint : this.getNavPoints()) {
                x += navPoint.getLocation().x;
                y += navPoint.getLocation().y;
                z += navPoint.getLocation().z;
            }
            this.center = new SPLocation(x / (double)this.getNavPoints().size(), y / (double)this.getNavPoints().size(), z / (double)this.getNavPoints().size());
        }
        return this.center;
    }

    public NavPoint getCenterNavPoint() {
        if (this.centerNavPoint == null) {
            this.centerNavPoint = this.getNearestNavPoint(this.getCenter());
        }
        return this.centerNavPoint;
    }

    public NavPoint getRandomNavPoint() {
        if (this.getNavPointsList().size() == 0) {
            return null;
        }
        return this.getNavPointsList().get(random.nextInt(this.getNavPointsList().size()));
    }

    public NavPoint getNearestNavPoint(SPLocation location) {
        Point3d loc = location.asPoint3d();
        double nearestDistance = Double.MAX_VALUE;
        NavPoint nearest = null;
        for (NavPoint navPoint : this.getNavPoints()) {
            double distance = loc.distance(navPoint.getLocation().getPoint3d());
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = navPoint;
        }
        return nearest;
    }

    public NavPoint getFurthestNavPoint(SPLocation location) {
        Point3d loc = location.asPoint3d();
        double furthestDistance = Double.MAX_VALUE;
        NavPoint furthest = null;
        for (NavPoint navPoint : this.getNavPoints()) {
            double distance = loc.distance(navPoint.getLocation().getPoint3d());
            if (!(distance > furthestDistance)) continue;
            furthestDistance = distance;
            furthest = navPoint;
        }
        return furthest;
    }

    public Map<NavPoint, Double> getNavPointDistances(SPLocation location) {
        HashMap<NavPoint, Double> distances = new HashMap<NavPoint, Double>();
        for (NavPoint navPoint : this.getNavPoints()) {
            distances.put(navPoint, navPoint.getLocation().getPoint3d().distance(location.asPoint3d()));
        }
        return distances;
    }

    public Map<Double, NavPoint> getNavPointDistancesSwapped(SPLocation location) {
        HashMap<Double, NavPoint> distances = new HashMap<Double, NavPoint>();
        for (NavPoint navPoint : this.getNavPoints()) {
            distances.put(navPoint.getLocation().getPoint3d().distance(location.asPoint3d()), navPoint);
        }
        return distances;
    }

    public NavPoint getRandomNavPoint(SPLocation location, double distance) {
        if (distance >= 1.0) {
            return this.getFurthestNavPoint(location);
        }
        Map<Double, NavPoint> distances = this.getNavPointDistancesSwapped(location);
        if (distance <= 0.0) {
            Collection<NavPoint> navPoints = distances.values();
            int num = random.nextInt(navPoints.size());
            Iterator<NavPoint> np = navPoints.iterator();
            for (int i = 0; i < num - 1; ++i) {
                np.next();
            }
            return np.next();
        }
        Double[] keys = distances.keySet().toArray(new Double[distances.keySet().size()]);
        Arrays.sort(keys, new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o1, o2);
            }
        });
        int randomInt = Double.valueOf(Math.round((1.0 - distance) * (double)keys.length)).intValue();
        int index = 0;
        index = randomInt > 1 ? keys.length - 1 - random.nextInt(randomInt) : keys.length - 1;
        if (index < 0) {
            System.out.println("huh");
        }
        NavPoint navPoint = distances.get(keys[index]);
        return navPoint;
    }

    public String toString() {
        return this.name.getToken();
    }

    public boolean contains(SPStoryPlace place) {
        if (place == this) {
            return true;
        }
        return this.getContainsAllPlaces().contains(place);
    }
}

