/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.base3d.agent.IAgent3D;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.IUDKBot;
import cz.cuni.amis.pogamut.udk.bot.IUDKBotController;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.translator.bot.BotFSM;
import cz.cuni.amis.pogamut.udk.communication.worldview.UDKSyncLockableWorldView;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKCommunicationModule;
import cz.cuni.amis.utils.token.IToken;
import java.lang.annotation.Annotation;

public class UDKBotModule<PARAMS extends UDKAgentParameters>
extends UDKCommunicationModule<PARAMS> {
    protected AdaptableProvider<ComponentDependencies> worldViewDependenciesProvider = new AdaptableProvider(null);
    private Class<? extends IUDKBotController> botControllerClass;

    protected UDKBotModule() {
    }

    public UDKBotModule(Class<? extends IUDKBotController> botControllerClass) {
        this.botControllerClass = botControllerClass;
    }

    @Override
    public void prepareNewAgent(PARAMS agentParameters) {
        super.prepareNewAgent(agentParameters);
        this.worldViewDependenciesProvider.set((Object)new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IToken)agentParameters.getAgentId()));
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            public void configure() {
                this.bind(IWorldMessageTranslator.class).to(BotFSM.class);
                this.bind(IWorldView.class).to(IVisionWorldView.class);
                this.bind(IVisionWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableWorldView.class).to(ILockableVisionWorldView.class);
                this.bind(ILockableVisionWorldView.class).to(UDKSyncLockableWorldView.class);
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"UDKSyncLockableWorldViewDependency")).toProvider(UDKBotModule.this.worldViewDependenciesProvider);
                this.bind(IAgent.class).to(IAgent3D.class);
                this.bind(IAgent3D.class).to(IUDKBot.class);
                this.bind(IUDKBot.class).to(UDKBot.class);
                if (UDKBotModule.this.botControllerClass != null) {
                    this.bind(IUDKBotController.class).to(UDKBotModule.this.botControllerClass);
                }
            }
        });
    }
}

