/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.bot.impl;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.udk.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.udk.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.udk.agent.navigation.UDKAStarPathPlanner;
import cz.cuni.amis.pogamut.udk.agent.navigation.UDKPathExecutor;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.udk.bot.command.AdvancedShooting;
import cz.cuni.amis.pogamut.udk.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBotLogicController;
import java.util.Random;
import java.util.logging.Logger;

public class UDKBotModuleController<BOT extends UDKBot>
extends UDKBotLogicController<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected ItemDescriptors descriptors;
    protected Items items;
    protected Senses senses;
    protected Weaponry weaponry;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected CompleteBotCommandsWrapper body;
    protected AdvancedShooting shoot;
    protected AdvancedLocomotion move;
    protected IPathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected IVisionWorldView world;
    protected IAct act;

    @Override
    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UDKAStarPathPlanner((UDKBot)bot);
        this.pathExecutor = new UDKPathExecutor((UDKBot)bot);
    }

    protected void initializeModules(BOT bot) {
        this.game = new Game((UDKBot)bot);
        this.info = new AgentInfo((UDKBot)bot, this.game);
        this.players = new Players((UDKBot)bot);
        this.descriptors = new ItemDescriptors((UDKBot)bot);
        this.items = new Items((UDKBot)bot, this.info);
        this.senses = new Senses((UDKBot)bot, this.info, this.players);
        this.weaponry = new Weaponry((UDKBot)bot, this.descriptors);
        this.config = new AgentConfig((UDKBot)bot);
        this.raycasting = new Raycasting((UDKBot)bot);
        this.body = new CompleteBotCommandsWrapper((UDKBot)bot);
        this.shoot = this.body.getShooting();
        this.move = this.body.getLocomotion();
    }
}

