package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;

import org.junit.Assert;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapper;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;

public class EventWrapperWithCallCountConverter implements Converter {

	private WorldViewTestContext ctx;
	
	public EventWrapperWithCallCountConverter(WorldViewTestContext ctx) {
		this.ctx = ctx;
	}

	@Override
	public void marshal(Object value, HierarchicalStreamWriter writer,
			MarshallingContext context) {
		
		EventWrapperWithCallCount wrapper_with_count = (EventWrapperWithCallCount)value;
		
		writer.addAttribute("count", Integer.toString(wrapper_with_count.getExpectedNumberOfCalls()));
		writer.startNode("Wrapper");
		writer.addAttribute("class", wrapper_with_count.getEventWrapper().getClass().getName());
		context.convertAnother(wrapper_with_count.getEventWrapper());
		writer.endNode();
	}

	@Override
	public Object unmarshal(HierarchicalStreamReader reader,
			UnmarshallingContext context) {
		
		int expectedNumberOfCalls = Integer.parseInt(reader.getAttribute("count"));
		
		reader.moveDown();
		String eventWrapperClassName = reader.getAttribute("class");
		try {
			EventWrapper wrapper = (EventWrapper) context.convertAnother(this,
					Class.forName(eventWrapperClassName));
			
			EventWrapperWithCallCount wrapper_with_count =
				new EventWrapperWithCallCount(ctx, wrapper, expectedNumberOfCalls);
			reader.moveUp();
			return wrapper_with_count;			
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			Assert.fail("Could not find sub-class of EventWrapper: " + eventWrapperClassName + ", referenced in plan");
		}
		reader.moveUp();
		
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean canConvert(Class clazz) {
		return EventWrapperWithCallCount.class.isAssignableFrom(clazz);
	}

}
