/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.utils;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentDescriptor;
import cz.cuni.amis.pogamut.base.agent.utils.runner.impl.MultipleAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.udk.agent.params.UDKAgentParameters;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotFactory;
import cz.cuni.amis.pogamut.udk.factory.guice.remoteagent.UDKBotModule;
import cz.cuni.amis.pogamut.udk.utils.PogamutUDKProperty;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.List;
import java.util.logging.Level;

public class MultipleUDKBotRunner<BOT extends UDKBot, PARAMS extends UDKAgentParameters, MODULE extends UDKBotModule>
extends MultipleAgentRunner<BOT, PARAMS, MODULE> {
    protected String host;
    protected int port;
    protected String name;

    public MultipleUDKBotRunner(String name, String host, int port) {
        this.name = name;
        this.port = port;
        this.host = host;
    }

    public MultipleUDKBotRunner(String name) {
        this(name, Pogamut.getPlatform().getProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutUDKProperty.POGAMUT_UDK_BOT_PORT.getKey()));
    }

    public String getName() {
        return this.name;
    }

    public MultipleUDKBotRunner<BOT, PARAMS, MODULE> setName(String name) {
        if (name == null) {
            name = "UDKBot";
        }
        this.name = name;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public MultipleUDKBotRunner<BOT, PARAMS, MODULE> setHost(String host) {
        this.host = host;
        NullCheck.check((Object)this.host, (String)"host");
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public MultipleUDKBotRunner<BOT, PARAMS, MODULE> setPort(int port) {
        this.port = port;
        return this;
    }

    protected void preStartHook(BOT agent) throws PogamutException {
        agent.getLogger().setLevel(Level.WARNING);
    }

    protected IAgentParameters newDefaultAgentParameters() {
        return new UDKAgentParameters().setAgentId((IAgentId)new AgentId(this.name)).setWorldAddress((IWorldConnectionAddress)new SocketConnectionAddress(this.host, this.port));
    }

    protected IAgentFactory newAgentFactory(MODULE agentModule) {
        return new UDKBotFactory(agentModule);
    }

    public List<BOT> startAgents(IAgentDescriptor<PARAMS, MODULE> ... agentDescriptors) {
        return super.startAgents(agentDescriptors);
    }
}

