/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.communication.worldview.testplan.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.udk.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.udk.communication.worldview.testplan.wrapper.InputEventWrapper;
import org.junit.Assert;

public class InputEventWrapperConverter
implements Converter {
    private WorldViewTestContext ctx;

    public InputEventWrapperConverter(WorldViewTestContext ctx) {
        this.ctx = ctx;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        InputEventWrapper wrapper = (InputEventWrapper)value;
        writer.addAttribute("raiseTimes", Integer.toString(wrapper.getRaiseTimes()));
        writer.startNode("Wrapper");
        writer.addAttribute("class", wrapper.getEvent().getClass().getName());
        context.convertAnother((Object)wrapper.getEvent());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int raiseTimes = Integer.parseInt(reader.getAttribute("raiseTimes"));
        reader.moveDown();
        try {
            IWorldChangeEvent event = (IWorldChangeEvent)context.convertAnother((Object)this, Class.forName(reader.getAttribute("class")));
            reader.moveUp();
            InputEventWrapper wrapper = new InputEventWrapper(event, raiseTimes);
            return wrapper;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Invalid class encountered as an InputEvent in InputEventWrapper. In " + reader.getNodeName()));
            return null;
        }
    }

    public boolean canConvert(Class clazz) {
        return InputEventWrapper.class.isAssignableFrom(clazz);
    }
}

