package cz.cuni.amis.pogamut.udk.utils;

public enum PogamutUDKProperty {
	/**
	 * Where the bot should connect to (hostname of the server running
	 * GameBotsUDK)
	 */
	POGAMUT_UDK_BOT_HOST("pogamut.udk.bot.host"),

	/**
	 * Where the bot should connect to (bot port of the GameBotsUDK).
	 */
	POGAMUT_UDK_BOT_PORT("pogamut.udk.bot.port"),

	/**
	 * Where the server should connect to (hostname of the server running
	 * GameBotsUDK)
	 */
	POGAMUT_UDK_SERVER_HOST("pogamut.udk.server.host"),

	/**
	 * Where the server should connect to (server port of the GameBotsUDK)
	 */
	POGAMUT_UDK_SERVER_PORT("pogamut.udk.server.port"),

	/**
	 * Where the observer should connect to (hostname of the server running
	 * GameBotsUDK)
	 */
	POGAMUT_UDK_OBSERVER_HOST("pogamut.udk.observer.host"),

	/**
	 * Where the observer should connect to (observer port of the GameBotsUDK)
	 */
	POGAMUT_UDK_OBSERVER_PORT("pogamut.udk.observer.port"),

	/** Path to the Unreal home dir. */
	POGAMUT_UNREAL_HOME("pogamut.udk.home"),

	/** Should tests use external UCC instance or they will run internal one? */
	POGAMUT_UNREAL_TEST_EXT_SERVER("pogamut.test.useExternalUCC");

	private String key;

	private PogamutUDKProperty(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}

	public String toString() {
		return key;
	}
}
