/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorHelper;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.BasePathExecutor;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.navigation.IUDKPathNavigator;
import cz.cuni.amis.pogamut.udk.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.SetRoute;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UDKPathExecutorWithPlanner<PATH_ELEMENT extends ILocated>
extends BasePathExecutor<PATH_ELEMENT> {
    private IUDKPathNavigator<PATH_ELEMENT> navigator;
    private UDKBot bot;
    private Self self;
    private IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>>(){

        public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
            UDKPathExecutorWithPlanner.this.self = (Self)event.getObject();
        }
    };
    private IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UDKPathExecutorWithPlanner.this.eventEndMessage();
        }
    };

    public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner) {
        this(bot, pathPlanner, null, null);
    }

    public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner, IUDKPathNavigator<PATH_ELEMENT> navigator) {
        this(bot, pathPlanner, navigator, null);
    }

    public UDKPathExecutorWithPlanner(UDKBot bot, IPathPlanner<PATH_ELEMENT> pathPlanner, IUDKPathNavigator<PATH_ELEMENT> navigator, Logger log) {
        super(log);
        if (this.getLog() == null) {
            this.setLog((Logger)bot.getLogger().getCategory(((Object)((Object)this)).getClass().getSimpleName()));
        }
        NullCheck.check((Object)bot, (String)"bot");
        this.bot = bot;
        this.navigator = navigator;
        if (this.navigator == null) {
            this.navigator = new LoqueNavigator(bot, this.getLog());
        }
        this.navigator.setBot(bot);
        this.navigator.setExecutor((IPathExecutorHelper<PATH_ELEMENT>)this);
        bot.getWorldView().addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, this.selfListener);
        bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
    }

    protected void stopped() {
    }

    protected void followPathImpl() {
    }

    protected void pathComputedImpl() {
        if (this.getPath().size() == 0) {
            this.targetReached();
        } else {
            this.bot.getAct().act((CommandMessage)new SetRoute().setRoute(this.getPath()));
            this.navigator.newPath(this.getPath());
        }
    }

    protected void pathComputationFailedImpl() {
    }

    protected void stuckImpl() {
        this.navigator.reset();
    }

    protected void switchToAnotherPathElementImpl() {
        List path = this.getPath();
        if (path.size() > 31 + this.getPathElementIndex()) {
            ArrayList pathPart = new ArrayList(32);
            for (int i = this.getPathElementIndex(); i < path.size() && i < this.getPathElementIndex() + 31; ++i) {
                pathPart.add(path.get(i));
            }
            this.bot.getAct().act((CommandMessage)new SetRoute().setRoute(pathPart));
        }
    }

    protected void targetReachedImpl() {
        this.navigator.reset();
    }

    protected void eventEndMessage() {
        if (this.inState(new PathExecutorState[]{PathExecutorState.PATH_COMPUTED}) || this.inState(new PathExecutorState[]{PathExecutorState.SWITCHED_TO_ANOTHER_PATH_ELEMENT})) {
            this.navigator.navigate();
        }
    }
}

