/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvents;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogMessage;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLLogRecorder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.AxisWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.LogEventWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.LogMessageWidget;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.TLScene;
import java.awt.Color;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.Widget;

public class LogCategoryWidget
extends AxisWidget
implements TLLogRecorder.TLLogRecorderListener {
    private static Border border = BorderFactory.createRoundedBorder((int)0, (int)0, (Color)Color.LIGHT_GRAY, (Color)Color.DARK_GRAY);
    private TLLogRecorder logRecorder;
    private LinkedList<LogMessageWidget> logMessageWidgets = new LinkedList();
    private LinkedList<LogEventWidget> logEventWidgets = new LinkedList();

    protected LogCategoryWidget(TLScene scene, TLLogRecorder logRecorder) {
        super(scene, logRecorder.getEntity(), logRecorder.getName(), 5, border);
        this.setVisible(false);
        this.logRecorder = logRecorder;
        this.logRecorder.addLogRecordListener(this);
        LogEvents logEvents = logRecorder.getLogEvents();
        for (LogMessage lm : logEvents.getMessages()) {
            this.onNewLogMessage(lm);
        }
        for (LogEvent le : logEvents.getEvents()) {
            this.onNewLogEvent(le);
        }
    }

    @Override
    public void updateWidget() {
        super.updateWidget();
        for (LogEventWidget logEventWidget : this.logEventWidgets) {
            logEventWidget.updateLocation();
        }
    }

    @Override
    public void onNewLogEvent(LogEvent newEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        LogEventWidget lew = new LogEventWidget(this, newEvent);
        this.logEventWidgets.add(lew);
        this.addChild((Widget)lew);
        this.setVisible(true);
        this.getScene().validate();
    }

    @Override
    public void onNewLogMessage(LogMessage newMessage) {
        assert (SwingUtilities.isEventDispatchThread());
        LogMessageWidget lmw = new LogMessageWidget(this, newMessage);
        this.logMessageWidgets.add(lmw);
        this.addChild(lmw);
        this.setVisible(true);
        this.getScene().validate();
    }
}

