/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class CurrentTimeWidget
extends Widget {
    private TLDatabase db;
    private static final int width = 6;
    private static final int height = 400;
    private static final Stroke lineStroke = new BasicStroke(6.0f);
    private final TLDatabase.Adapter currentTimeListener = new TLDatabase.Adapter(){

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
            CurrentTimeWidget.this.setLocationAccordingToTime(CurrentTimeWidget.this.db.getDeltaTime());
        }
    };

    public CurrentTimeWidget(Scene scene, TLDatabase database) {
        super(scene);
        this.db = database;
        this.setLocationAccordingToTime(this.db.getDeltaTime());
        this.db.addDBListener(this.currentTimeListener);
        this.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)new TimeDragStrategy(), (MoveProvider)new TimeChangeProvider()));
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(-4, 0, 8, 400);
    }

    protected void paintWidget() {
        Graphics2D g = this.getGraphics();
        Stroke formerStroke = g.getStroke();
        g.setColor(Color.RED);
        g.setStroke(lineStroke);
        g.drawLine(0, 0, 0, 400);
        g.setStroke(formerStroke);
    }

    private void setLocationAccordingToTime(long ms) {
        int x = (int)(80L + ms / 100L);
        this.setPreferredLocation(new Point(x, 0));
        this.getScene().validate();
    }

    private class TimeChangeProvider
    implements MoveProvider {
        private Point originalLocation;

        private TimeChangeProvider() {
        }

        public void movementStarted(Widget widget) {
            this.originalLocation = widget.getLocation();
            System.out.println("Original location " + this.originalLocation);
        }

        public void movementFinished(Widget widget) {
        }

        public Point getOriginalLocation(Widget arg0) {
            return this.originalLocation;
        }

        public void setNewLocation(Widget widget, Point location) {
            System.out.println("Set location " + location);
            widget.setPreferredLocation(new Point(this.originalLocation.x + location.x, this.originalLocation.y + location.y));
        }
    }

    private class TimeDragStrategy
    implements MoveStrategy {
        private TimeDragStrategy() {
        }

        public Point locationSuggested(Widget widget, Point original, Point suggested) {
            int x = suggested.x;
            System.out.print("Move strategy " + original + " (" + widget.convertSceneToLocal(original) + ") " + suggested);
            System.out.println(" -> " + x);
            Point res = new Point(suggested.x - original.x, 0);
            System.out.println("MoveStrategy result " + res);
            return res;
        }
    }
}

