/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.view;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;

class TLToolbar
extends JToolBar {
    private static final long REPLAY_PERIOD = 200L;
    private TLDatabase db;
    private Timer timer = null;
    private PlayTask playTask = null;
    private final AbstractAction startPlaying = new AbstractAction("Play"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TLToolbar.this.playTask != null) {
                return;
            }
            TLToolbar.this.playTask = new PlayTask();
            TLToolbar.this.getTimer().schedule((TimerTask)TLToolbar.this.playTask, 200L, 200L);
        }
    };
    private final AbstractAction stopPlayback = new AbstractAction("Stop"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TLToolbar.this.playTask == null) {
                return;
            }
            TLToolbar.this.playTask.cancel();
            TLToolbar.this.playTask = null;
        }
    };

    public TLToolbar(TLDatabase db) {
        this.db = db;
        this.add(this.startPlaying);
        this.add(this.stopPlayback);
    }

    protected TLDatabase getDB() {
        return this.db;
    }

    private Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer("PlayTimelineThread");
        }
        return this.timer;
    }

    private class PlayTask
    extends TimerTask {
        private long last = 0L;

        private PlayTask() {
        }

        @Override
        public void run() {
            if (this.last == 0L) {
                this.last = Calendar.getInstance().getTimeInMillis();
            }
            long current = Calendar.getInstance().getTimeInMillis();
            long taskDelta = current - this.last;
            long newDBCurrent = TLToolbar.this.db.getCurrentTime() + taskDelta;
            this.last = current;
            if (newDBCurrent > TLToolbar.this.db.getEndTime()) {
                this.cancel();
                TLToolbar.this.getTimer().purge();
                TLToolbar.this.playTask = null;
                return;
            }
            TLToolbar.this.db.setCurrentTime(newDBCurrent);
        }
    }
}

