/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLAgentEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLFolder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLProperty;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import java.util.Calendar;
import java.util.List;
import javax.swing.SwingWorker;

public class TLEntityUpdater
extends SwingWorker<Boolean, Long> {
    protected TLAgentEntity entity;
    protected IUnrealBot agent;
    protected int interval = 100;

    public TLEntityUpdater(TLAgentEntity entity, IUnrealBot agent) {
        this.entity = entity;
        this.agent = agent;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        while (((IAgentState)this.agent.getState().getFlag()).isState(new Class[]{IAgentStateUp.class}) && !this.isCancelled()) {
            long timestamp = Calendar.getInstance().getTimeInMillis();
            this.entity.botLocation.update(timestamp);
            this.entity.botRotation.update(timestamp);
            this.entity.botVelocity.update(timestamp);
            this.syncFolder(this.agent.getIntrospection(), this.entity.storageFolder, timestamp);
            this.publish(timestamp);
            Thread.sleep(this.interval);
        }
        return true;
    }

    @Override
    protected void done() {
        this.entity.finish();
    }

    @Override
    protected void process(List<Long> endTimestamps) {
        long endTime = endTimestamps.get(endTimestamps.size() - 1);
        this.entity.setEndTime(endTime);
    }

    protected void syncFolder(Folder folder, TLFolder tlFolder, long time) throws IntrospectionException {
        this.syncProperties(folder, tlFolder, time);
        for (Folder subFolder : folder.getFolders()) {
            String folderName = subFolder.getName();
            TLFolder tlSubFolder = tlFolder.findFolder(folderName);
            if (tlSubFolder == null) {
                tlSubFolder = new TLFolder(folderName);
                tlFolder.addFolder(tlSubFolder);
            }
            this.syncFolder(subFolder, tlSubFolder, time);
        }
    }

    private void syncProperties(Folder folder, TLFolder tlFolder, long time) throws IntrospectionException {
        for (Property property : folder.getProperties()) {
            String propertyName = property.getName();
            Class propertyType = property.getType();
            Object propertyValue = property.getValue();
            TLProperty tlProperty = tlFolder.findProperty(propertyName);
            if (tlProperty == null) {
                tlProperty = new TLProperty(propertyName, propertyType);
                tlFolder.addProperty(tlProperty);
            }
            tlProperty.addValue(propertyValue, time);
        }
    }
}

