/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.services;

import cz.cuni.amis.nb.pogamut.unreal.services.ISelectionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AgentSelection<E> {
    private E selected = null;
    private Set<ISelectionListener<E>> listeners = new HashSet<ISelectionListener<E>>();

    public synchronized void changeSelected(E newSelection) {
        E oldSelected = this.selected;
        this.selected = newSelection;
        this.fireSelectionPropertyChange(oldSelected, newSelection);
    }

    public synchronized void addSelectionListener(ISelectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeSelectionListener(ISelectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireSelectionPropertyChange(E oldSelection, E newSelection) {
        ArrayList<ISelectionListener<E>> listenersArray = new ArrayList<ISelectionListener<E>>(this.listeners);
        for (ISelectionListener iSelectionListener : listenersArray) {
            iSelectionListener.selectionChanged(oldSelection, newSelection);
        }
    }
}

