/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.options;

import cz.cuni.amis.nb.pogamut.options.TimelineOptionsPanelController;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class TimelinePanel
extends JPanel {
    private final TimelineOptionsPanelController controller;
    public static final String INCLUDE_FLAG_KEY = "includeFlagToRendering";
    private ButtonGroup FlagsBehaviorRadioGroup;
    private JButton defaultFlagsBtn;
    private JCheckBox doorFlagCheckBox;
    private JRadioButton excludeFlagsRadioButton;
    private JCheckBox flyFlagCheckBox;
    private JCheckBox forcedFlagCheckBox;
    private JPanel highColorArea;
    private JRadioButton includeFlagsRadioButton;
    private JCheckBox jumpFlagCheckBox;
    private JCheckBox ladderFlagCheckBox;
    private JPanel lowColorArea;
    private JPanel mapFlagsPanel;
    private JButton mapHighColorBtn;
    private JButton mapLowColorBtn;
    private JCheckBox playerOnlyFlagCheckBox;
    private JCheckBox proscribedFlagCheckBox;
    private JCheckBox specialFlagCheckBox;
    private JCheckBox swimFlagCheckBox;
    private JCheckBox walkFlagCheckBox;
    private JPanel waypointsColorArea;
    private JButton waypointsColorBtn;

    TimelinePanel(TimelineOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.FlagsBehaviorRadioGroup = new ButtonGroup();
        this.mapFlagsPanel = new JPanel();
        this.walkFlagCheckBox = new JCheckBox();
        this.flyFlagCheckBox = new JCheckBox();
        this.swimFlagCheckBox = new JCheckBox();
        this.jumpFlagCheckBox = new JCheckBox();
        this.doorFlagCheckBox = new JCheckBox();
        this.specialFlagCheckBox = new JCheckBox();
        this.ladderFlagCheckBox = new JCheckBox();
        this.proscribedFlagCheckBox = new JCheckBox();
        this.forcedFlagCheckBox = new JCheckBox();
        this.playerOnlyFlagCheckBox = new JCheckBox();
        this.defaultFlagsBtn = new JButton();
        this.highColorArea = new JPanel();
        this.mapHighColorBtn = new JButton();
        this.mapLowColorBtn = new JButton();
        this.lowColorArea = new JPanel();
        this.waypointsColorBtn = new JButton();
        this.waypointsColorArea = new JPanel();
        this.includeFlagsRadioButton = new JRadioButton();
        this.excludeFlagsRadioButton = new JRadioButton();
        this.mapFlagsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(TimelinePanel.class, (String)"LBL_MapFlagsPanel")));
        Mnemonics.setLocalizedText((AbstractButton)this.walkFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.walkFlagCheckBox.text"));
        this.walkFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.walkFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.flyFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.flyFlagCheckBox.text"));
        this.flyFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.flyFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.swimFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.swimFlagCheckBox.text"));
        this.swimFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.swimFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jumpFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.jumpFlagCheckBox.text"));
        this.jumpFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.jumpFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.doorFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.doorFlagCheckBox.text"));
        this.doorFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.doorsFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.specialFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.specialFlagCheckBox.text"));
        this.specialFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.specialFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ladderFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.ladderFlagCheckBox.text"));
        this.ladderFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.ladderFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.proscribedFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.proscribedFlagCheckBox.text"));
        this.proscribedFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.proscribedFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.forcedFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.forcedFlagCheckBox.text"));
        this.forcedFlagCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimelinePanel.this.forcedFlagCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.playerOnlyFlagCheckBox, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.playerOnlyFlagCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.defaultFlagsBtn, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.defaultFlagsBtn.text"));
        this.defaultFlagsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.defaultFlagsBtnActionPerformed(evt);
            }
        });
        GroupLayout mapFlagsPanelLayout = new GroupLayout(this.mapFlagsPanel);
        this.mapFlagsPanel.setLayout(mapFlagsPanelLayout);
        mapFlagsPanelLayout.setHorizontalGroup(mapFlagsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapFlagsPanelLayout.createSequentialGroup().addGroup(mapFlagsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.swimFlagCheckBox).addComponent(this.jumpFlagCheckBox).addComponent(this.doorFlagCheckBox).addComponent(this.specialFlagCheckBox).addComponent(this.ladderFlagCheckBox).addComponent(this.proscribedFlagCheckBox).addComponent(this.forcedFlagCheckBox).addComponent(this.playerOnlyFlagCheckBox).addGroup(mapFlagsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultFlagsBtn)).addComponent(this.flyFlagCheckBox).addComponent(this.walkFlagCheckBox)).addContainerGap(11, Short.MAX_VALUE)));
        mapFlagsPanelLayout.setVerticalGroup(mapFlagsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapFlagsPanelLayout.createSequentialGroup().addComponent(this.walkFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flyFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.swimFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jumpFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.doorFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.specialFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ladderFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proscribedFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.forcedFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playerOnlyFlagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.defaultFlagsBtn).addContainerGap(-1, Short.MAX_VALUE)));
        this.highColorArea.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout highColorAreaLayout = new GroupLayout(this.highColorArea);
        this.highColorArea.setLayout(highColorAreaLayout);
        highColorAreaLayout.setHorizontalGroup(highColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        highColorAreaLayout.setVerticalGroup(highColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.mapHighColorBtn, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.mapHighColorBtn.text"));
        this.mapHighColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.mapHighColorBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mapLowColorBtn, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.mapLowColorBtn.text"));
        this.mapLowColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.mapLowColorBtnActionPerformed(evt);
            }
        });
        this.lowColorArea.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout lowColorAreaLayout = new GroupLayout(this.lowColorArea);
        this.lowColorArea.setLayout(lowColorAreaLayout);
        lowColorAreaLayout.setHorizontalGroup(lowColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        lowColorAreaLayout.setVerticalGroup(lowColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.waypointsColorBtn, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.waypointsColorBtn.text"));
        this.waypointsColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.waypointsColorBtnActionPerformed(evt);
            }
        });
        this.waypointsColorArea.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout waypointsColorAreaLayout = new GroupLayout(this.waypointsColorArea);
        this.waypointsColorArea.setLayout(waypointsColorAreaLayout);
        waypointsColorAreaLayout.setHorizontalGroup(waypointsColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        waypointsColorAreaLayout.setVerticalGroup(waypointsColorAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        this.FlagsBehaviorRadioGroup.add(this.includeFlagsRadioButton);
        this.includeFlagsRadioButton.setSelected(true);
        this.includeFlagsRadioButton.setToolTipText(NbBundle.getMessage(TimelinePanel.class, (String)"LBL_IncludeFlags"));
        this.includeFlagsRadioButton.setLabel(NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.includeFlagsRadioButton.label"));
        this.includeFlagsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.includeFlagsRadioButtonActionPerformed(evt);
            }
        });
        this.FlagsBehaviorRadioGroup.add(this.excludeFlagsRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.excludeFlagsRadioButton, (String)NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.jRadioButton2.text"));
        this.excludeFlagsRadioButton.setToolTipText(NbBundle.getMessage(TimelinePanel.class, (String)"LBL_ForceFlags"));
        this.excludeFlagsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimelinePanel.this.excludeFlagsRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mapFlagsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waypointsColorBtn, -1, -1, Short.MAX_VALUE).addComponent(this.mapLowColorBtn, -1, -1, Short.MAX_VALUE).addComponent(this.mapHighColorBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waypointsColorArea, -1, -1, Short.MAX_VALUE).addComponent(this.lowColorArea, -1, -1, Short.MAX_VALUE).addComponent(this.highColorArea, -1, -1, Short.MAX_VALUE))).addComponent(this.includeFlagsRadioButton).addComponent(this.excludeFlagsRadioButton)).addGap(399, 399, 399)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mapFlagsPanel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.highColorArea, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.mapHighColorBtn, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lowColorArea, -1, -1, Short.MAX_VALUE).addComponent(this.mapLowColorBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.waypointsColorArea, -1, -1, Short.MAX_VALUE).addComponent(this.waypointsColorBtn, -1, -1, Short.MAX_VALUE)).addGap(26, 26, 26).addComponent(this.includeFlagsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeFlagsRadioButton))).addContainerGap(100, Short.MAX_VALUE)));
    }

    private void defaultFlagsBtnActionPerformed(ActionEvent evt) {
        this.walkFlagCheckBox.setSelected(MapFlag.WALK.getDefault());
        this.flyFlagCheckBox.setSelected(MapFlag.FLY.getDefault());
        this.swimFlagCheckBox.setSelected(MapFlag.SWIM.getDefault());
        this.jumpFlagCheckBox.setSelected(MapFlag.JUMP.getDefault());
        this.doorFlagCheckBox.setSelected(MapFlag.DOOR.getDefault());
        this.specialFlagCheckBox.setSelected(MapFlag.SPECIAL.getDefault());
        this.ladderFlagCheckBox.setSelected(MapFlag.LADDER.getDefault());
        this.proscribedFlagCheckBox.setSelected(MapFlag.PROSCRIBED.getDefault());
        this.forcedFlagCheckBox.setSelected(MapFlag.FORCED.getDefault());
        this.playerOnlyFlagCheckBox.setSelected(MapFlag.PLAYER_ONLY.getDefault());
    }

    private void mapHighColorBtnActionPerformed(ActionEvent evt) {
        String title = NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.mapsHighColorChooser.title");
        Color chosenHighColor = JColorChooser.showDialog(this, title, this.highColorArea.getBackground());
        this.highColorArea.setBackground(chosenHighColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.HIGH_COLOR_KEY.getPrefKey(), chosenHighColor.getRGB());
    }

    private void mapLowColorBtnActionPerformed(ActionEvent evt) {
        String title = NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.mapsLowColorChooser.title");
        Color chosenLowColor = JColorChooser.showDialog(this, title, this.lowColorArea.getBackground());
        this.lowColorArea.setBackground(chosenLowColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.LOW_COLOR_KEY.getPrefKey(), chosenLowColor.getRGB());
    }

    private void waypointsColorBtnActionPerformed(ActionEvent evt) {
        String title = NbBundle.getMessage(TimelinePanel.class, (String)"TimelinePanel.mapWaypointsColorChooser.title");
        Color chosenWaypointsColor = JColorChooser.showDialog(this, title, this.waypointsColorArea.getBackground());
        this.waypointsColorArea.setBackground(chosenWaypointsColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), chosenWaypointsColor.getRGB());
    }

    private void walkFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.WALK.getPrefKey(), this.walkFlagCheckBox.isSelected());
    }

    private void flyFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.FLY.getPrefKey(), this.flyFlagCheckBox.isSelected());
    }

    private void swimFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.SWIM.getPrefKey(), this.swimFlagCheckBox.isSelected());
    }

    private void jumpFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.JUMP.getPrefKey(), this.jumpFlagCheckBox.isSelected());
    }

    private void doorsFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.DOOR.getPrefKey(), this.doorFlagCheckBox.isSelected());
    }

    private void specialFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.SPECIAL.getPrefKey(), this.specialFlagCheckBox.isSelected());
    }

    private void ladderFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.LADDER.getPrefKey(), this.ladderFlagCheckBox.isSelected());
    }

    private void proscribedFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.PROSCRIBED.getPrefKey(), this.proscribedFlagCheckBox.isSelected());
    }

    private void forcedFlagCheckBoxStateChanged(ChangeEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.FORCED.getPrefKey(), this.forcedFlagCheckBox.isSelected());
    }

    private void includeFlagsRadioButtonActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(INCLUDE_FLAG_KEY, true);
    }

    private void excludeFlagsRadioButtonActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(TimelinePanel.class).putBoolean(INCLUDE_FLAG_KEY, false);
    }

    void load() {
        Preferences pref = NbPreferences.forModule(TimelinePanel.class);
        this.walkFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.WALK));
        this.flyFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.FLY));
        this.swimFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.SWIM));
        this.jumpFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.JUMP));
        this.doorFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.DOOR));
        this.specialFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.SPECIAL));
        this.ladderFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.LADDER));
        this.proscribedFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.PROSCRIBED));
        this.forcedFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.FORCED));
        this.playerOnlyFlagCheckBox.setSelected(this.getPrefBoolean(pref, MapFlag.PLAYER_ONLY));
        this.lowColorArea.setBackground(this.getPrefColor(pref, MapColor.LOW_COLOR_KEY));
        this.highColorArea.setBackground(this.getPrefColor(pref, MapColor.HIGH_COLOR_KEY));
        this.waypointsColorArea.setBackground(this.getPrefColor(pref, MapColor.WAYPOINTS_COLOR_KEY));
        if (pref.getBoolean(INCLUDE_FLAG_KEY, true)) {
            this.includeFlagsRadioButton.setSelected(true);
        } else {
            this.excludeFlagsRadioButton.setSelected(true);
        }
    }

    private Color getPrefColor(Preferences pref, MapColor color) {
        return new Color(pref.getInt(color.getPrefKey(), color.getDegaultARGB()));
    }

    private boolean getPrefBoolean(Preferences pref, MapFlag flag) {
        return pref.getBoolean(flag.getPrefKey(), flag.getDefault());
    }

    void store() {
        Preferences pref = NbPreferences.forModule(TimelinePanel.class);
        pref.putBoolean(MapFlag.WALK.getPrefKey(), this.walkFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.FLY.getPrefKey(), this.flyFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.SWIM.getPrefKey(), this.swimFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.JUMP.getPrefKey(), this.jumpFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.DOOR.getPrefKey(), this.doorFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.SPECIAL.getPrefKey(), this.specialFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.LADDER.getPrefKey(), this.ladderFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.PROSCRIBED.getPrefKey(), this.proscribedFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.FORCED.getPrefKey(), this.forcedFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.PLAYER_ONLY.getPrefKey(), this.playerOnlyFlagCheckBox.isSelected());
        Color lowColor = this.lowColorArea.getBackground();
        pref.putInt(MapColor.LOW_COLOR_KEY.getPrefKey(), lowColor.getRGB());
        Color highColor = this.highColorArea.getBackground();
        pref.putInt(MapColor.HIGH_COLOR_KEY.getPrefKey(), highColor.getRGB());
        Color waypointsColor = this.waypointsColorArea.getBackground();
        pref.putInt(MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), waypointsColor.getRGB());
        pref.putBoolean(INCLUDE_FLAG_KEY, this.includeFlagsRadioButton.isSelected());
    }

    boolean valid() {
        return true;
    }

    public static enum MapFlag {
        WALK("mapFlagWalk", 1, true),
        FLY("mapFlagFlyFly", 2, false),
        SWIM("mapFlagSwim", 4, false),
        JUMP("mapFlagJump", 8, false),
        DOOR("mapFlagDoor", 16, true),
        SPECIAL("mapFlagSpecial", 32, true),
        LADDER("mapFlagLadder", 64, true),
        PROSCRIBED("mapFlagProscribed", 128, true),
        FORCED("mapFlagForced", 256, true),
        PLAYER_ONLY("mapFlagPlayerOnly", 512, true);

        private final String prefKey;
        private final int flag;
        private final boolean defaultValue;

        private MapFlag(String prefKey, int flag, boolean defaultValue) {
            this.prefKey = prefKey;
            this.flag = flag;
            this.defaultValue = defaultValue;
        }

        public String getPrefKey() {
            return this.prefKey;
        }

        public boolean getDefault() {
            return this.defaultValue;
        }

        public int getFlag() {
            return this.flag;
        }

        public String toString() {
            return this.prefKey;
        }
    }

    public static enum MapColor {
        LOW_COLOR_KEY("mapLowColorARGB", Color.WHITE.getRGB()),
        HIGH_COLOR_KEY("mapHighColorARGB", Color.RED.getRGB()),
        WAYPOINTS_COLOR_KEY("mapWaypointsColorARGB", new Color(0.6f, 0.6f, 0.6f).getRGB());

        private String prefKey;
        private int defaultARGB;

        private MapColor(String prefKey, int defaultARGB) {
            this.prefKey = prefKey;
            this.defaultARGB = defaultARGB;
        }

        public String getPrefKey() {
            return this.prefKey;
        }

        public int getDegaultARGB() {
            return this.defaultARGB;
        }

        public Color getDefaultColor() {
            return new Color(this.defaultARGB);
        }
    }
}

