/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.api.pogamut.base.server.ServersManager;
import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.pogamut.base.server.IWorldServer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.Action;
import org.openide.nodes.Node;

public abstract class ServersRootNode<T extends ServerDefinition>
extends ObservableCollectionNode<T> {
    protected ServersManager<T> manager = null;

    public ServersRootNode(ServersManager<T> manager) {
        super(manager.getAllServers(), new NodeFactory<T>(){

            @Override
            public Node[] create(T obj) {
                return new Node[]{((ServerDefinition)obj).getViewer()};
            }
        });
        this.manager = manager;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new NamedAction("ACT_AddServer"){

            @Override
            public void action(ActionEvent e) throws PogamutException {
                Object server = ServersRootNode.this.createNewServer();
                ServersRootNode.this.manager.getAllServers().add(server);
                ServersRootNode.this.manager.getDefaultServer().setFlag(server);
            }
        }, null, new NamedAction("ACT_RemoveAll"){

            @Override
            protected void action(ActionEvent e) throws PogamutException {
                LinkedList servers = new LinkedList(ServersRootNode.this.manager.getAllServers());
                ServersRootNode.this.manager.getAllServers().clear();
                for (ServerDefinition def : servers) {
                    IWorldServer server = (IWorldServer)def.getServerFlag().getFlag();
                    if (server == null) continue;
                    server.stop();
                }
            }
        }};
    }

    protected abstract T createNewServer();
}

