package cz.cuni.amis.nb.util;

import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.PropertySupport;

/**
 * Prop name is autogenerated.
 * @author ik
 */
public abstract class AutoNamedProp<T> extends PropertySupport<T> {

    protected static final String PROP_NAME_PREFIX = "UP_PROP_";
    /** Counter of <code>FlagPropertyAdapter</code>s. */
    protected static long propCounter = 0;

    public AutoNamedProp(
            Class<T> type,
            String displayName,
            String shortDescription,
            boolean canWrite) {
        super(PROP_NAME_PREFIX + (propCounter++), type, displayName, shortDescription, true, canWrite);
    }

}
