/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.introspection;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.FolderShadow;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.nb.pogamut.base.introspection.PropertyAdapter;
import cz.cuni.amis.nb.util.Updater;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.Image;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class FolderNode
extends AbstractNode {
    Folder folder = null;
    protected Set<PropertyAdapter> propertyAdapters = new HashSet<PropertyAdapter>();

    public FolderNode(Folder folder) {
        super((Children)new IntrospectionChildren(folder));
        this.setName(folder.getName());
        this.folder = folder;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"cz/cuni/amis/nb/pogamut/base/introspection/IntrospectionRootIcon.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        try {
            if (this.folder.getProperties() != null) {
                for (Property p : this.folder.getProperties()) {
                    PropertyAdapter.NamedAdapter adapter = new PropertyAdapter.NamedAdapter(p);
                    props.put((Node.Property)adapter);
                    this.propertyAdapters.add(adapter);
                }
            }
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    protected void updateProps() {
        for (PropertyAdapter prop : this.propertyAdapters) {
            try {
                this.firePropertyChange(prop.getPropertyID(), null, prop.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Node n : this.getChildren().getNodes()) {
            ((FolderNode)n).updateProps();
        }
    }

    protected static class IntrospectionChildren
    extends Children.Keys {
        protected Folder parent;

        public IntrospectionChildren(Folder parent) {
            this.parent = parent;
        }

        protected void addNotify() {
            try {
                if (this.parent.getFolders() == null) {
                    this.setKeys(Collections.EMPTY_SET);
                } else {
                    this.setKeys(this.parent.getFolders());
                }
            }
            catch (IntrospectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object obj) {
            return new Node[]{new FolderNode((Folder)obj)};
        }
    }

    public static class Root
    extends FolderNode {
        TimerTask guiUpdaterTask = null;
        TimerTask propUpdaterTask = null;
        protected WeakReference<IAgent> agent = null;
        protected FlagListener<IAgentState> stopUpdatingListener = null;

        public Root(IAgent agent, Updater updater) throws IntrospectionException {
            super((Folder)new FolderShadow(agent.getIntrospection()));
            this.agent = new WeakReference<IAgent>(agent);
            this.setDisplayName("Introspection");
            updater.addUpdateTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((FolderShadow)Root.this.getFolder()).synchronize();
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                    Root.this.updateProps();
                }
            });
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }
}

