/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.agent;

import cz.cuni.amis.nb.pogamut.base.agent.AgentAction;
import cz.cuni.amis.nb.pogamut.base.agent.AgentNode;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;

public abstract class ControllableAgentNode<T extends IAgent>
extends AgentNode<T> {
    protected static Timer updater = new Timer("Agent node periodical updater");
    protected TimerTask updaterTask = new TimerTask(){

        @Override
        public void run() {
            for (Runnable r : ControllableAgentNode.this.updateSubtasks) {
                r.run();
            }
        }
    };
    protected FlagListener<IAgentState> stopUpdatingListener = null;
    protected static final long UPDATE_PERIOD = 500L;

    public ControllableAgentNode(final T agent) {
        super(agent);
        updater.schedule(this.updaterTask, 500L, 500L);
        this.stopUpdatingListener = new FlagListener<IAgentState>(){

            public void flagChanged(IAgentState changedValue) {
                if (ControllableAgentNode.this.isEndState(changedValue)) {
                    ControllableAgentNode.this.updaterTask.cancel();
                    agent.getState().removeListener(ControllableAgentNode.this.stopUpdatingListener);
                }
            }
        };
        agent.getState().addListener((FlagListener)this.stopUpdatingListener);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new StopAgent(this.agent), new KillAgent(this.agent), null, new PauseAgent(this.agent), new ResumeAgent(this.agent)};
    }

    public static class SetDefault
    extends AgentAction {
        public SetDefault(IAgent agent) {
            super(agent, "ACT_SetDefault");
        }

        @Override
        protected void action(ActionEvent e) throws AgentException {
        }
    }

    public static class KillAgent
    extends AgentAction {
        public KillAgent(IAgent agent) {
            super(agent, "ACT_Kill");
        }

        @Override
        protected void action(ActionEvent e) throws AgentException {
            this.agent.kill();
        }
    }

    public static class ResumeAgent
    extends AgentAction {
        public ResumeAgent(IAgent agent) {
            super(agent, "ACT_Resume");
        }

        @Override
        protected void action(ActionEvent e) throws AgentException {
            this.agent.resume();
        }
    }

    public static class PauseAgent
    extends AgentAction {
        public PauseAgent(IAgent agent) {
            super(agent, "ACT_Pause");
        }

        @Override
        protected void action(ActionEvent e) throws AgentException {
            this.agent.pause();
        }
    }

    public static class StopAgent
    extends AgentAction {
        public StopAgent(IAgent agent) {
            super(agent, "ACT_Stop");
        }

        @Override
        protected void action(ActionEvent e) throws AgentException {
            this.agent.stop();
        }
    }
}

