/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.logging;

import cz.cuni.amis.nb.pogamut.base.logging.LogRecordsSource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;

public class LogProxy
extends LogRecordsSource<LogRecord> {
    protected static String[] levelNames = new String[9];
    protected static int[] levelVals = new int[9];
    protected static Level[] levels = new Level[]{Level.ALL, Level.SEVERE, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.OFF};
    protected static Map<Level, Integer> levelToIndex = new HashMap<Level, Integer>();
    protected Handler handler;
    LogRecordsSource.Filter filter;

    public LogProxy(Logger log) {
        for (int i = 0; i < levels.length; ++i) {
            levelToIndex.put(levels[i], i);
            LogProxy.levelNames[i] = levels[i].getLocalizedName();
            LogProxy.levelVals[i] = i;
        }
        this.handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                LogProxy.this.addMessage(record);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        this.filter = null;
        log.addHandler(this.handler);
        log.setLevel(Level.ALL);
        this.filter = new FilterLog(Level.ALL);
        this.addFilter(this.filter);
    }

    @Override
    public void setRegexpFilterPatter(Pattern pattern) {
        if (pattern == null) {
            this.removeFilter(this.regexpFilter);
        } else {
            this.regexpFilter = (LogRecordsSource.RegexpFilter)this.replaceFilter(this.regexpFilter, new LogRecordsSource.RegexpFilter<LogRecord>(pattern){

                @Override
                public boolean filter(LogRecord r) {
                    return this.pattern.matcher(r.getMessage()).matches();
                }
            });
        }
    }

    @Override
    public Sheet.Set getPropSet() {
        Sheet.Set props = super.getPropSet();
        PropertySupport.ReadWrite p = new PropertySupport.ReadWrite("loglevel", Integer.class, "Log level", ""){

            public void setValue(Object val) {
                LogProxy.this.filter = LogProxy.this.replaceFilter(LogProxy.this.filter, new FilterLog(levels[(Integer)val]));
            }

            public Object getValue() {
                Integer i = levelToIndex.get(((FilterLog)LogProxy.this.filter).getLevel());
                return i;
            }
        };
        p.setValue("intValues", (Object)levelVals);
        p.setValue("stringKeys", (Object)levelNames);
        props.put((Node.Property)p);
        return props;
    }

    @Override
    protected LogRecord toLogRecord(LogRecord t) {
        return t;
    }

    @Override
    protected LogRecord getLogRecParam(LogRecord lr) {
        return lr;
    }

    protected class FilterLog
    implements LogRecordsSource.Filter<LogRecord> {
        protected Level level = Level.ALL;

        public Level getLevel() {
            return this.level;
        }

        public FilterLog(Level level) {
            this.level = level;
        }

        @Override
        public boolean filter(LogRecord t) {
            return t.getLevel().intValue() >= this.level.intValue();
        }
    }
}

