/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.api.pogamut.base.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.api.pogamut.base.server.ServersManager;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import cz.cuni.amis.utils.collections.SimpleListener;
import cz.cuni.amis.utils.flag.Flag;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;

public abstract class DefaultServersManager<T extends ServerDefinition>
implements ServersManager<T> {
    String serverType = null;
    protected String serversListFileName;
    protected ObservableList<T> servers = new ObservableList(new ArrayList());
    Flag<T> defaultServer = new Flag();

    public DefaultServersManager(String serverType) {
        this.serverType = serverType;
        this.serversListFileName = serverType + "ServersList.bin";
        this.deserialize();
        this.servers.addCollectionListener((CollectionEventListener)new SimpleListener(){

            protected void changed(Collection collection, Collection added, Collection removed) {
                DefaultServersManager.this.serialize();
            }
        });
    }

    @Override
    public Flag<T> getDefaultServer() {
        return this.defaultServer;
    }

    @Override
    public ObservableCollection<T> getAllServers() {
        return this.servers;
    }

    @Override
    public abstract void deserialize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize() {
        try {
            FileObject writeTo = this.getServerListFile();
            FileLock lock = writeTo.lock();
            try {
                ObjectOutputStream str = new ObjectOutputStream(writeTo.getOutputStream(lock));
                try {
                    str.writeObject(this.servers.getList());
                }
                finally {
                    str.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    protected FileObject getServerListFile() throws IOException {
        FileObject serversFile;
        FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileObject folder = root.getFileObject(this.serverType);
        if (folder == null) {
            folder = root.createFolder(this.serverType);
        }
        if ((serversFile = folder.getFileObject(this.serversListFileName)) == null) {
            serversFile = folder.createData(this.serversListFileName);
        }
        return serversFile;
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public void removeServer(T server) {
        ((ServerDefinition)server).stopServer();
        this.servers.remove(server);
    }
}

