/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import java.util.List;

/**
 * Base for all implementations of {@link ILevelMetaDataProvider}. Provides]
 * the "single" variants of all calls using the other methods, throwing {@link NoUniqueMetaDataException}
 * if there are no or more than one candidates for the metadata.
 * @author MaCe
 */
public abstract class AbstractLevelMetadataProvider<ObjectId> implements ILevelMetaDataProvider<ObjectId> {

    @Override
    public <T extends IConnectedMetaData<? extends ObjectId>> T getSingleConnectedMetaData(ObjectId targetObject, Class<T> clazz) {
        List<T> allMetadata = getConnectedMetaData(targetObject, clazz);
        if(allMetadata.size() != 1){
            throw new NoUniqueMetaDataException(clazz, allMetadata.size());
        }
        return allMetadata.get(0);
    }

    @Override
    public <T> T getSingleMetaData(Class<T> clazz) {
        List<T> allMetadata = getMetaData(clazz);
        if(allMetadata.size() != 1){
            throw new NoUniqueMetaDataException(clazz, allMetadata.size());
        }
        return allMetadata.get(0);
    }

}
