/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import java.util.List;

/**
 * Basic interface for all classes that provide metadata for particular level.
 * @param <ObjectId> type that uniquely identifies an object in the level.
 * @author Martin Cerny
 */
public interface ILevelMetaDataProvider<ObjectId> {
    /**
     * Gets all metadata avaliable, regardless of class. Returns all
     * metadata connected to some particular object as well.
     * @return
     */
    public List<Object> getAllMetaData();

    /**
     * Returns all metadata of a particular class.
     * @param <T>
     * @param clazz the type of metadata to be returned.
     * @return
     */
    public <T> List<T> getMetaData(Class<T> clazz);

    /**
     * Returns singleton metadata instance of a particular class.
     * @param <T>
     * @param clazz the class of metadata to be returned
     * @return
     * @throws NoUniqueMetaDataException if there are more or less than one candidates to be returned.
     */
    public <T> T getSingleMetaData(Class<T> clazz);

    /**
     * Returns all metadata connected to a certain object.
     * @param targetObject
     * @return
     */
    public List<IConnectedMetaData<? extends ObjectId>> getAllConnectedMetaData(ObjectId targetObject);

    /**
     * Returns all metadata of particular class connected to a certain object
     * @param <T>
     * @param targetObject
     * @param clazz the class of metadata to be returned
     * @return
     */
    public <T extends IConnectedMetaData<? extends ObjectId>> List<T> getConnectedMetaData(ObjectId targetObject, Class<T> clazz);


    /**
     * Returns singleton metadata instance of a particular class connected to a certain object.
     * @param <T>
     * @param clazz the class of metadata to be returned
     * @param targetObject 
     * @return
     * @throws NoUniqueMetaDataException if there are more or less than one candidates to be returned.
     */
    public <T extends IConnectedMetaData<? extends ObjectId>> T getSingleConnectedMetaData(ObjectId targetObject, Class<T> clazz);
}
