/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import java.util.HashMap;
import java.util.Map;

/**
 * A simple implementation of {@link ILevelMetaDataProviderFactory} that is backed by
 * an externally specified map od level identification to metadata providers.
 * @author Martin Cerny
 */
public class MapLevelMetaDataProviderFactory<ObjectId, LevelIdentificator> implements ILevelMetaDataProviderFactory<ObjectId, LevelIdentificator> {
    private Map<LevelIdentificator, ILevelMetaDataProvider<ObjectId>> providers;

    public MapLevelMetaDataProviderFactory(Map<LevelIdentificator, ILevelMetaDataProvider<ObjectId>> providers) {
        this.providers = providers;
    }

    public MapLevelMetaDataProviderFactory() {
        this.providers = new HashMap<LevelIdentificator, ILevelMetaDataProvider<ObjectId>>();
    }



    public void addProviders(Map<? extends LevelIdentificator, ? extends ILevelMetaDataProvider<ObjectId>> newProviders) {
        providers.putAll(newProviders);
    }

    public void addProvider(LevelIdentificator levelIdentifiaction, ILevelMetaDataProvider<ObjectId> provider) {
        providers.put(levelIdentifiaction, provider);
    }



    /**
     * Returns a provider associated with a level. If the level identification is not found in the backing map,
     * an empty metadata provider is returned (ie. the provider returned contains no metadata).
     * @param levelIdentification
     * @return
     */
    @Override
    public ILevelMetaDataProvider<ObjectId> getMetadataProvider(LevelIdentificator levelIdentification) {
        ILevelMetaDataProvider<ObjectId> provider = providers.get(levelIdentification);
        if(provider != null){
            return provider;
        } else {
            //No metadata found, returning provider with no metadata
            return new ListLevelMetaDataProvider<ObjectId>();
        }
    }


}
