/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import java.util.ArrayList;
import java.util.List;

/**
 * An abstract implementation of {@link ILevelMetaDataProvider} that
 * expects the overriding class to provide list of all avaliable metadata
 * and then extracts the desired subset of metadat by filtering this list.
 * @author Martin Cerny
 */
public abstract class AbstractFilteringLevelMetaDataProvider<ObjectId> extends AbstractLevelMetadataProvider<ObjectId> {

    @Override
    public List<IConnectedMetaData<? extends ObjectId>> getAllConnectedMetaData(ObjectId targetObject) {
        return getConnectedMetaData(targetObject, IConnectedMetaData.class);
    }

    @Override
    public <T extends IConnectedMetaData<? extends ObjectId>> List<T> getConnectedMetaData(ObjectId targetObject, Class<T> clazz) {
        List<T> result = new ArrayList<T>();
        for (Object o : getAllMetaData()) {
            if (clazz.isAssignableFrom(o.getClass())) {
                T con = (T) o;
                if (con.getConnectedObjectId().equals(targetObject)) {
                    result.add(con);
                }
            }
        }
        return result;
    }

    @Override
    public <T> List<T> getMetaData(Class<T> clazz) {
        List<T> result = new ArrayList<T>();
        for (Object o : getAllMetaData()) {
            if (clazz.isAssignableFrom(o.getClass())) {
                result.add((T) o);
            }
        }
        return result;
    }
}
