package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.AbstractContainerItemReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.FoodTools;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplication;

/** Plate dish
 * 
 * Can hold food.
 */
public class DishwarePlateReplication extends AbstractContainerItemReplication implements IDishwarePlate {
	
	public static final float FOOD_CAPACITY = 1.5f; // food capacity in litres
	public static final String DISPLAY_NAME = "Plate";
	
	@Override
	public Collection<? extends IIngredientReplication> readIngredients() {
		return FoodTools.readIngredients( readInventory() );
	}
	
	@Override
	public String getDisplayName() {
		return DISPLAY_NAME;
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return FoodTools.canStoreFood( readIngredients(), item,  FOOD_CAPACITY );
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return false;
	}
}