package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.AbstractEssenceReplication;

/** Stove essence
 * 
 * Parent of stove plates.
 */
public class StoveReplication extends AbstractEssenceReplication implements IStove {

	public static final int PLATE_COUNT = 4;
	public static final int MAX_POWER = 6;

	public static final float HEAT_PER_POWER_PER_TICK = 18000.0f; // in joules
	public static final float HEATING_TICK_PERIOD = 1.0f; // seconds
	
	protected static final String PLATES_ATTR = "plates";
	protected static final String POWERS_ATTR = "powers";
	
	@Override
	public StovePlateReplication getPlate( int index ) {
		assert( 0 <= index && index < 4 );
		int i=0;
		for ( FoggyRefReplication ref : attributes.refLists().read( PLATES_ATTR ) ) {
			if ( i == index ) {
				if ( ref.isHidden() ) {
					return null;
				} else {
					return (StovePlateReplication) ref.get();
				}
			}
			++i;
		}
		throw new AssertionError( "Invalid index." );
	}
	
	@Override
	public int getPower( int index ) {
		assert( 0 <= index && index < PLATE_COUNT );
		int i=0;
		for ( Integer value : attributes.intLists().read( POWERS_ATTR ) ) {
			if ( i == index ) {
				return  value;
			}
			++i;
		}
		throw new AssertionError( "Invalid index." );
	}
}