package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Class holding all allowed character types with their Unreal classes.
 * @author Knight
 */
public enum CharacterType {

    CAMERA("Camera","GBEmohawk.Camera","", false, 0),
    THOMAS("Thomas","GBEmohawk.StoryCharThomas","GameBotsUDK.PogamutPawnThomas", true, 1),
    NATALIE("Natalie","GBEmohawk.StoryCharNatalie","GameBotsUDK.PogamutPawnNatalie", false, 2),
    BARBARA("Barbara","GBEmohawk.StoryCharBarbara","GameBotsUDK.PogamutPawnBarbara", false, 3),
    EMOHAWK("Emohawk","GBEmohawk.StoryCharEmohawk","GameBotsUDK.PogamutPawnEmohawk", false, 4),
    UDN_MALE("UDNMale","GBEmohawk.StoryCharUDNMale","GameBotsUDKSF.PawnRBCasual01m", true, 5),
    UDN_FEMALE("UDNFemale","GBEmohawk.StoryCharUDNFemale","GameBotsUDKSF.PawnRBCasual01f", false, 6),
    VICTOR("Viktor","GBEmohawk.StoryCharCasual01m","GameBotsUDKSF.PawnRBCasual01m", true, 7),
    ANDREA("Andrea","GBEmohawk.StoryCharCasual01f","GameBotsUDKSF.PawnRBCasual01f", false, 8),
    VERONIQUE("Veronika", "GBEmohawk.StoryCharBusiness01f","GameBotsUDKSF.PawnRBBusiness01f", false, 9),
    PATRICK("Patrik","GBEmohawk.StoryCharBusiness02m","GameBotsUDKSF.PawnRBBusiness02m", true, 10),
    KATE("Katka","GBEmohawk.StoryCharCasual02f","GameBotsUDKSF.PawnRBCasual02f", false, 11),
    SARKA("Sarka","GBEmohawk.StoryCharCasual03f","GameBotsUDKSF.PawnRBCasual03f", false, 12),
    TUAN("Tuan","GBEmohawk.StoryCharCasual04m","GameBotsUDKSF.PawnRBCasual04m", true, 13),
    CHARLES("Karel","GBEmohawk.StoryCharCasual06m","GameBotsUDKSF.PawnRBCasual06m", true, 14),
    DOMINIQUE("Dominik", "GBEmohawk.StoryCharCasual07m", "GameBotsUDKSF.PawnRBCasual07m",true, 15),
    PAUL("Pavel","GBEmohawk.StoryCharCasual08m","GameBotsUDKSF.PawnRBCasual08m",true, 16),
    CYRIL("Cyril","GBEmohawk.StoryCharCasual10m","GameBotsUDKSF.PawnRBCasual10m",true, 17),
    PETER("Petr","GBEmohawk.StoryCharCasual11m","GameBotsUDKSF.PawnRBCasual11m",true, 18),
    MILOS("Milos","GBEmohawk.StoryCharCasual13m", "GameBotsUDKSF.PawnRBCasual13m",true, 19),
    LUBOS("Lubos","GBEmohawk.StoryCharCasual14m","GameBotsUDKSF.PawnRBCasual14m",true, 20),
    SIMONA("Simona","GBEmohawk.StoryCharCasual15f","GameBotsUDKSF.PawnRBCasual15f", false, 21),
    MILAN("Milan","GBEmohawk.StoryCharCasual16m","GameBotsUDKSF.PawnRBCasual16m",true, 22),
    VENDY("Vendula","GBEmohawk.StoryCharCasual17f","GameBotsUDKSF.PawnRBCasual17f", false, 23),
    RUDOLPH("Rudolf","GBEmohawk.StoryCharCasual19m","GameBotsUDKSF.PawnRBCasual19m",true, 24),
    EDUARD("Eduard","GBEmohawk.StoryCharCasual20m","GameBotsUDKSF.PawnRBCasual20m",true, 25),
    DUONG("Duong","GBEmohawk.StoryCharCasual22m","GameBotsUDKSF.PawnRBCasual22m",true, 26),
    JOANNA("Joanna","GBEmohawk.StoryCharCasual23f","GameBotsUDKSF.PawnRBCasual23f", false, 27),
    NGUYEN("Nguyen","GBEmohawk.StoryCharCasual23m","GameBotsUDKSF.PawnRBCasual23m",true, 28),
    MICHAELA("Michaela","GBEmohawk.StoryCharCasual24f","GameBotsUDKSF.PawnRBCasual24f", false, 29),
    JAROSLAV("Jarek","GBEmohawk.StoryCharCasual24m","GameBotsUDKSF.PawnRBCasual24m",true, 30),
    SUZAN("Zuzana","GBEmohawk.StoryCharCasual26f","GameBotsUDKSF.PawnRBCasual26f", false, 31),
    RADEK("Radek","GBEmohawk.StoryCharCasual31m","GameBotsUDKSF.PawnRBCasual31m",true, 32),
    JOHN("Honza","GBEmohawk.StoryCharSoccerPlayer01m","GameBotsUDKSF.PawnRBSoccerPlayer01m",true, 33),
    MIA("Mia","GBEmohawk.StoryCharSportive01f","GameBotsUDKSF.PawnRBSportive01f", false, 34),
    LUCY("Lucie","GBEmohawk.StoryCharSportive02f","GameBotsUDKSF.PawnRBSportive02f", false, 35),
    MARK("Marek","GBEmohawk.StoryCharSportive03m","GameBotsUDKSF.PawnRBSportive03m",true, 36),
    EVE("Eva","GBEmohawk.StoryCharSportive04f","GameBotsUDKSF.PawnRBSportive04f", false, 37),
    KAMILA("Kamila","GBEmohawk.StoryCharSportive05f","GameBotsUDKSF.PawnRBSportive05f", false, 38),
    IRENE("Irena","GBEmohawk.StoryCharSportive06f","GameBotsUDKSF.PawnRBSportive06f", false, 39),
    IVAN("Ivan","GBEmohawk.StoryCharSportive08m","GameBotsUDKSF.PawnRBSportive08m",true, 40);

    String name;
    String ue2Class;
    String udkClass;
    boolean bIsMale;
    int characterID;

    CharacterType(String name, String text, String textUDK, boolean bIsMale, int characterID) {
        this.name = name;
        this.ue2Class = text;
        this.udkClass = textUDK;
        this.bIsMale = bIsMale;
        this.characterID = characterID;
    }

    public static Collection<CharacterType> getCollection() {
        ArrayList<CharacterType> result = new ArrayList<CharacterType>();

        for (CharacterType type : CharacterType.values()) {
            result.add(type);
        }

        return result;
    }

    public String getUE2Class() {
        return ue2Class;
    }

    public String getUDKClass() {
        return udkClass;
    }

    public boolean isMale() {
        return bIsMale;
    }

    public int getCharacterID() {
        return characterID;
    }

    @Override
    public String toString() {
        return name;
    }
}
