package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;


/** Unreal script template specialization replicated to Java
 * 
 * Template specializations are replicated as generic java classes. Generic type parameters are
 * erased in the runtime but template specialization can access type parameter freely. This interface
 * therefore defines method setTypeParameter which is called after construction to provide opportunity
 * to store type parameters.
 * 
 * Requires non-parametric constructor.
 * 
 * @author Paletz
 */
public interface IGenericObjectReplica extends IObjectReplica {
	
	/** Set type parameter
	 * 
	 * @param index index of type parameter
	 * @param value type parameter
	 */
	public void setTypeParameter( int index, SpecializedClass<?> value );
	
	/** Get type parameter
	 * 
	 * @param index index of queried type parameter
	 * @raturn type parameter
	 */
	public SpecializedClass<?> getTypeParameter( int index );
	
	/** Get type parameter count
	 *
	 * @return type paramter count
	 */
	public int getTypeParameterCount();
}
