package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive;

import java.util.Arrays;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** Primitive attribute view
 * 
 * Filters attribute not matching given list type.
 */
public class PrimitiveAttributeView<T> implements IPrimitiveAttributeView<T> {

	protected AttributeRawView<PrimitiveAttributeReplication<T>,T> rawView;
	protected Class<T> primitiveClass;
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public PrimitiveAttributeView( Class<T> primitiveClass, ListMapReplication<IAttributeReplication> attributes, AttributeUpstream upstream ) {
		this.primitiveClass = primitiveClass;
		rawView = new AttributeRawView<PrimitiveAttributeReplication<T>,T>( 
			attributes,
			upstream,
			new SpecializedClass<PrimitiveAttributeReplication<T>>(
				(Class) PrimitiveAttributeReplication.class,
				Arrays.asList( new SpecializedClass<?>[] { SpecializedClass.fromPlain( primitiveClass ) } ) 
			)
		);
	}
	
	@Override
	public T get( String attributeName ) {
		PrimitiveAttributeReplication<T> attribute = rawView.getAttributeRecord( attributeName );
		PrimitiveBoxReplication<T> pbox = attribute.getValue();
		assert( pbox.getValueClass().equals( SpecializedClass.fromPlain( primitiveClass ) ) );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return pbox.get();	
	}
	
	@Override
	public void set( String attributeName, T value ) {
		rawView.send( attributeName, value );
	}
	
	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplication<PrimitiveAttributeReplication<T>>> iterator() {
		return rawView.iterator();
	}
}