package cz.cuni.amis.pogamut.emohawk.agent.module.attribute;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.emohawk.communication.attribute.SetAttribute;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;

/** Attribute upstream
 * 
 * Allows setting of attribute values on Unreal server from pogamut.
 * 
 * @author Paletz
 */
public class AttributeUpstream {
	
	protected UT2004Bot<?,?,?> bot;
	protected StreamManager streamManager;
	protected IEssenceMap essenceMap;
	
	public AttributeUpstream( UT2004Bot<?,?,?> bot, StreamManager streamManager, IEssenceMap essenceMap ) {
		this.bot = bot;
		this.streamManager = streamManager;
		this.essenceMap = essenceMap;
	}
	
	/** Get primitive data stream to Unreal server
	 * 
	 * This stream is used to send attribute input value.
	 * 
	 * @return primitive data stream to Unreal server
	 */
	public IOutputStream getOutputStream() {
		return streamManager.getOutputStream();
	}
	
	/** Get controller ID of the bot
	 * 
	 * @return controller ID of the bot
	 */
	public int getControllerId() {
		return essenceMap.retrieveController( bot.getSelf().getBotId().getStringId() ).getControllerId();
	}
	
	/** Set attribute value on server
	 * 
	 * @param replicationId replication ID of the attribute
	 */
	public void setAttribute( ReplicationId replicationId ) {
		bot.getAct().act( new SetAttribute( replicationId ) );
	}
}
