/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.bot.impl;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Animations;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmohawkNavigation;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Inventory;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Places;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Steering;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathNavigator;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import java.util.Random;
import java.util.logging.Logger;

public class EmohawkBotController<BOT extends UT2004Bot<?, ?, ?>>
extends UT2004BotLogicController<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected Senses senses;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected AdvancedLocomotion move;
    protected Communication comm;
    protected UT2004PathExecutor<ILocated> pathExecutor = null;
    protected IPathPlanner<ILocated> pathPlanner = null;
    protected NavigationGraphBuilder navBuilder;
    protected UT2004GetBackToNavGraph getBackToNavGraph;
    protected UT2004RunStraight runStraight;
    protected UT2004Navigation navigation;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected EmohawkNavigation emohawkNavigation;
    protected IVisionWorldView world;
    protected IAct act;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected Animations animations;
    protected Emoticons emoticons;
    protected Places places;
    protected Steering steering;
    protected Inventory inventory;
    protected ObjectReplicationClient objectReplicationClient;
    protected StreamManager streamManager;
    protected IEssenceMap essenceMap;
    protected AttributeUpstream attributeUpstream;
    protected ActionUpstream actionUpstream;
    protected IObservationMemory observationMemory;
    protected final IReplicatedObjectTracker objectTracker = new IReplicatedObjectTracker(){

        @Override
        public IObjectReplication getObject(int id) {
            return EmohawkBotController.this.objectReplicationClient.getObject(id);
        }

        @Override
        public boolean exists(int id) {
            return EmohawkBotController.this.objectReplicationClient.exists(id);
        }
    };

    public void initializeController(BOT bot) {
        super.initializeController(bot);
        this.world = this.getWorldView();
        this.act = this.getAct();
        this.initializeModules(bot);
        this.initializePathFinding(bot);
        this.initializeListeners(bot);
    }

    public void finishControllerInitialization() {
    }

    public Random getRandom() {
        return this.random;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public Players getPlayers() {
        return this.players;
    }

    public Senses getSenses() {
        return this.senses;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public Communication getComm() {
        return this.comm;
    }

    public IUnrealPathExecutor<ILocated> getPathExecutor() {
        return this.pathExecutor;
    }

    public IPathPlanner<ILocated> getPathPlanner() {
        return this.pathPlanner;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public UT2004Navigation getNavigation() {
        return this.navigation;
    }

    public IReplicatedObjectTracker getReplicatedObjectTracker() {
        return this.objectReplicationClient;
    }

    public IEssenceMap getEssenceMap() {
        return this.essenceMap;
    }

    public IObservationMemory getObservationMemory() {
        return this.observationMemory;
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.pathPlanner = new UT2004AStarPathPlanner(bot);
        this.fwMap = new FloydWarshallMap(bot);
        this.pathExecutor = new UT2004PathExecutor(bot, (IUT2004PathNavigator)new LoqueNavigator(bot, (IUT2004PathRunner)new KefikRunner(bot, this.info, this.move, (Logger)bot.getLog()), (Logger)bot.getLog()));
        this.getBackToNavGraph = new UT2004GetBackToNavGraph(bot, this.info, this.move);
        this.runStraight = new UT2004RunStraight(bot, this.info, this.move);
        this.navigation = new UT2004Navigation(bot, this.pathExecutor, (IPathPlanner)this.fwMap, (IUT2004GetBackToNavGraph)this.getBackToNavGraph, (IUT2004RunStraight)this.runStraight);
        this.emohawkNavigation = new EmohawkNavigation((UT2004Bot<?, ?, ?>)bot, this.steering, this.fwMap);
    }

    protected void initializeModules(BOT bot) {
        assert (this.bot == bot);
        this.game = this.makeGame();
        this.info = this.makeAgentInfo();
        this.players = this.makePlayers();
        this.senses = this.makeSenses();
        this.config = this.makeAgentConfig();
        this.raycasting = this.makeRaycasting();
        this.move = this.makeAdvancedLocomotion();
        this.comm = this.makeCommunication();
        this.stats = this.makeAgentStats();
        this.navBuilder = this.makeNavBuilder();
        this.animations = this.makeAnimations();
        this.emoticons = this.makeEmoticons();
        this.places = this.makePlaces();
        this.steering = this.makeSteering();
        this.inventory = this.makeInventory();
        this.essenceMap = this.makeEssenceMap();
        this.streamManager = this.makeStreamManager();
        this.attributeUpstream = this.makeAttributeUpstream();
        this.actionUpstream = this.makeActionUpstream();
        this.objectReplicationClient = this.makeObjectReplicationClient((IUT2004Bot)bot, this.streamManager);
        this.objectReplicationClient.registerModule(EssenceMap.class, (EssenceMap)this.essenceMap);
        this.objectReplicationClient.registerModule(AttributeUpstream.class, this.attributeUpstream);
        this.objectReplicationClient.registerModule(ActionUpstream.class, this.actionUpstream);
        this.objectReplicationClient.registerModule(IWorldView.class, bot.getWorldView());
        this.observationMemory = this.makeObservationMemory();
    }

    protected Game makeGame() {
        return new Game(this.bot);
    }

    protected AgentInfo makeAgentInfo() {
        return new AgentInfo(this.bot, this.game);
    }

    protected Players makePlayers() {
        return new Players(this.bot);
    }

    protected Senses makeSenses() {
        return new Senses(this.bot, this.info, this.players);
    }

    protected AgentConfig makeAgentConfig() {
        return new AgentConfig(this.bot);
    }

    protected Raycasting makeRaycasting() {
        return new Raycasting(this.bot);
    }

    protected AdvancedLocomotion makeAdvancedLocomotion() {
        return new AdvancedLocomotion(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Move"));
    }

    protected Communication makeCommunication() {
        return new Communication(this.getBot(), (Logger)this.getBot().getLogger().getCategory("Communicaton"));
    }

    protected AgentStats makeAgentStats() {
        return new AgentStats((IObservingAgent)this.bot);
    }

    protected NavigationGraphBuilder makeNavBuilder() {
        return new NavigationGraphBuilder(this.bot);
    }

    protected Animations makeAnimations() {
        return new Animations(this.bot);
    }

    protected Emoticons makeEmoticons() {
        return new Emoticons(this.bot);
    }

    protected Places makePlaces() {
        return new Places(this.bot);
    }

    protected Steering makeSteering() {
        return new Steering(this.bot);
    }

    protected Inventory makeInventory() {
        return new Inventory(this.bot);
    }

    protected IEssenceMap makeEssenceMap() {
        return new EssenceMap(this.world);
    }

    protected StreamManager makeStreamManager() {
        return new StreamManager((IWorldView)this.world, this.act, this.objectTracker);
    }

    protected AttributeUpstream makeAttributeUpstream() {
        return new AttributeUpstream(this.bot, this.streamManager, this.essenceMap);
    }

    protected ActionUpstream makeActionUpstream() {
        return new ActionUpstream(this.bot.getAct(), (IWorldView)this.world, this.game, this.streamManager.getOutputStream(), this.log);
    }

    protected ObjectReplicationClient makeObjectReplicationClient(IUT2004Bot bot, StreamManager streamManager) {
        return new ObjectReplicationClient(bot, streamManager);
    }

    protected IObservationMemory makeObservationMemory() {
        return new ObservationMemory(this.act, this.world, this.essenceMap, this.info);
    }
}

