/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

public class SerializationTools {
    public static void serializeReplicationId(IOutputStream stream, ReplicationId replicationId) {
        stream.writeInt(replicationId.getIndex());
        stream.writeInt(replicationId.getGenerationNumber());
    }

    public static ReplicationId deserializeReplicationId(IInputStream stream) {
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        int index = stream.readInt();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        int generationNumber = stream.readInt();
        return new ReplicationId(index, generationNumber);
    }

    public static void serializeObjectReferenceOnClient(IOutputStream stream, IObjectReplication objectReference) {
        if (objectReference == null) {
            stream.writeInt(-1);
            stream.writeInt(0);
        } else {
            assert (objectReference.isLive());
            SerializationTools.serializeReplicationId(stream, objectReference.getReplicationId());
        }
    }

    public static void serializeLocation(IOutputStream stream, Location location) {
        stream.writeFloat((float)location.getX());
        stream.writeFloat((float)location.getY());
        stream.writeFloat((float)location.getZ());
    }

    public static Location deserializeVector(IInputStream stream) {
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float x = stream.readFloat();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float y = stream.readFloat();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float z = stream.readFloat();
        return new Location((double)x, (double)y, (double)z);
    }
}

