package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeManagerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeManagerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributedReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Abstract actor essence
 */
public abstract  class AbstractEssenceReplication extends AbstractObjectReplication implements IAttributedReplication, IEssenceReplication {
	
	protected IWorldView world;
	protected AttributeManagerReplication attributes;
	protected String actorId;
	protected int gameObjectId;
	
	@Override
	public IAttributeManagerReplication getAttributes() {
		return attributes;
	}
	
	@Override
	public void receive( IInputObjectStream stream ) {
		attributes = (AttributeManagerReplication) stream.readObjectRef();
		actorId = stream.readString();
		world = getObjectReplicationClient().getModule( IWorldView.class );
		if ( !actorId.isEmpty() ) {
			getObjectReplicationClient().getModule( EssenceMap.class ).associateEssence( actorId, this );
		}
		gameObjectId = stream.readInt();
	}
	
	@Override
	public int getGameObjectId() {
		return gameObjectId;
	}
	
	@Override
	public IWorldObject getActor() {
		return world.get( WorldObjectId.get( actorId ) );
	}
	
	@Override
	public Location getActorLocation() {
		if ( getActor() instanceof ILocated ) {
			return ((ILocated) getActor()).getLocation();
		} else {
			return null;
		}
	}
	
	@Override
	public WorldObjectId getActorId() {
		return WorldObjectId.get( actorId );
	}
}