package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;

/** Interface of view of attributes matching the templated primitive type
 * 
 * Provides exists, get and set operations. 
 */
public interface IPrimitiveAttributeView<T>  {

	/** Get value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value
	 */
	public T get( String attributeName );
	
	/** Set value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @param value new value
	 */
	public void set( String attributeName, T value );
	
	/** Tell if attribute exists and has the right type and access
	 *
	 * @param attributeName attribute name
	 * @param access required access
	 * @return true if attribute exists and has right type and access
	 */
	public boolean exists( String attributeName, AttributeAccess access );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	public Iterator<ListMapEntryReplication<PrimitiveAttributeReplication<T>>> iterator();
}