package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** Foggy reference list attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class FoggyRefListAttributeView implements IFoggyRefListAttributeView {
	
	protected AttributeRawView<FoggyRefListAttributeReplication, Iterable<IObjectReplication>> rawView;
		
	public FoggyRefListAttributeView( 
		ListMapReplication<IAttributeReplication> attributes,
		AttributeUpstream upstream 
	) {
		rawView = new AttributeRawView<FoggyRefListAttributeReplication, Iterable<IObjectReplication>>( 
			attributes,
			upstream,
			SpecializedClass.fromPlain( FoggyRefListAttributeReplication.class )
		);
	}
	
	@Override
	public SinglyLinkedListReplication<FoggyRefReplication> read( String attributeName ) {
		FoggyRefListAttributeReplication attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue();
	}

	@Override
	public void send( String attributeName, Iterable<IObjectReplication> value ) {
		rawView.send( attributeName, value );
	}

	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplication<FoggyRefListAttributeReplication>> iterator() {
		return rawView.iterator();
	}
}
