package cz.cuni.amis.pogamut.emohawk.agent.module.replication;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;

/** Interface of replicated object tracker
 * 
 * @author Paletz
 */
public interface IReplicatedObjectTracker {
	
	/** Get object by replication ID
	 * 
	 * It is an error to request undefined object.
	 * 
	 * @param replicationId replication ID
	 * @return object with required ID
	 */
	public IObjectReplication getObject( int replicationId );
	
	/** Tell if there is an replicated object with given ID
	 * 
	 * @param replicationId replication ID
	 * @return true if there is an replicated object with given ID
	 */
	public boolean exists( int replicationId );
}
