package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade;

import java.util.Collection;
import java.util.Iterator;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.AbstractProcessReplica;

/** Process of trading
 * 
 * @author Paletz
 */
public class TradeProcessReplica extends AbstractProcessReplica implements ITradeProcess {

	public static final String BARTER_PARTNER_ATTR = "barterPartner";
	public static final String HAS_ACCEPTED_ATTR = "hasAccepted";
	public static final String OFFER_ATTR = "offer";
	public static final String OFFER_IN_ATTR = "offer_in";
	public static final String HAS_ACCEPTED_IN_ATTR = "hasAccepted_in";
	public static final String LAST_OFFER_CHANGE_TIME_ATTR = "lastOfferChangeTime";
	
	@Override
	public boolean isBarterPartnerHidden() {
		return attributes.refs().isHidden( BARTER_PARTNER_ATTR );
	}
	
	@Override
	public IBartererReplica getBarterPartner() {
		return (IBartererReplica) attributes.refs().get( BARTER_PARTNER_ATTR );
	}

	@Override
	public TradeProcessReplica getBarterPartnerProcess() {
		if ( !isBarterPartnerHidden() && getBarterPartner() != null && getBarterPartner().getProcess() instanceof TradeProcessReplica ) {
			return (TradeProcessReplica) getBarterPartner().getProcess();
		} else {
			return null;
		}
	}

	@Override
	public boolean isEstablished() {
		return getBarterPartnerProcess() != null;
	}

	@Override
	public boolean hasAccepted() {
		return attributes.bools().get( HAS_ACCEPTED_ATTR );
	}

	@Override
	public Collection<? extends IItemReplica> readOffer()
	{
		return Collections2.transform( 
			attributes.refLists().read( OFFER_ATTR ),
			new Function<FoggyRefReplica,IItemReplica>() {
				@Override
				public IItemReplica apply( FoggyRefReplica arg ) {
					return (IItemReplica) arg.get();
				}
			}
		);
	}
	
	/** Send offer
	 * 
	 * @param offered items
	 */
	public void sendOffer( Iterable<IItemReplica> offer ) {
		final Iterable<IItemReplica> finalOffer = offer;
		getAttributes().refLists().send( 
			OFFER_IN_ATTR,
			new Iterable<IObjectReplica>() {
				@Override
				public Iterator<IObjectReplica> iterator() {
					final Iterator<IItemReplica> underlyingIterator = finalOffer.iterator();
					return new Iterator<IObjectReplica>() {
						@Override
						public boolean hasNext() {
							return underlyingIterator.hasNext();
						}

						@Override
						public IObjectReplica next() {
							return (IObjectReplica) underlyingIterator.next();
						}

						@Override
						public void remove() {
						}
					};
				}
			}
		);
	}

	/** Send if local side accepts offer
	 */
	public void sendHasAccepted( boolean value ) {
		attributes.bools().set( HAS_ACCEPTED_IN_ATTR, value );
	}
	
	@Override
	public float getLastOfferChangeTime() {
		return attributes.floats().get( LAST_OFFER_CHANGE_TIME_ATTR );
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		super.receive( stream );
	}
}
