package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;

/** Trade action
 * 
 * Starts execution that initially proposes trade to the target. Once both parties propose to each other actual trade execution is established.
 * Both performer and target must implement ErbIBarterer.
 */
public class TradeActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_TARGET_BUSY = 10;
	public static final int ERROR_PERFORMER_BUSY = 11;
	public static final int ERROR_TARGET_INVALID = 12;
	public static final int ERROR_PERFORMER_NOT_BARTERER = 13;
	public static final int ERROR_OUT_OF_RANGE = 14;

	public static final float DEFAULT_RANGE = 200.0f;
	public static final float DEFAULT_ACCEPTING_COOLDOWN_TIME = 2.5f;
	
	protected static final String RANGE_ATTR = "range"; 
	protected static final String ACCEPTING_COOLDOWN_TIME_ATTR = "acceptingCooldownTime";
	
	/** Constructor
	 */
	public TradeActionReplica() {
	}
	
	@Override
	public String getActionName()
	{
		return "Trade";
	}

	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Get accepting cooldown time
	 * 
	 * @return accepting cooldown time in seconds
	 */
	public float getAcceptingCooldownTime() {
		return attributes.floats().get( ACCEPTING_COOLDOWN_TIME_ATTR );
	}
	
	/** Tell if the two barterers can reach each other
	 */
	public boolean canReach( IBartererReplica a, IBartererReplica b, float rangeMultiplier )
	{
		return ( 
			EssenceDistanceTools.computeDistanceOfEssences( a, b ) 
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Request
	 *  
	 * @param performer action performer
	 * @param partner barter partner
	 * @param resultHandler result handler
	 */
	public void request( IBartererReplica performer, IBartererReplica partner, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, partner );
		performer.requestAction( 
			this,
			resultHandler,
			arguments
		);
	}

}


