package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IPerformerReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IExecutorReplica;

/** Interrupt action execution action
 */
public class InterruptProcessActionReplica extends AbstractActionReplica {
	
	/** Error code sent to the requester of the interrupted action
	 */
	public static final int ERROR_INTERRUPTED = 5;
	
	public static final int ERROR_PERFORMER_NOT_EXECUTOR = 10;
	public static final int ERROR_NOTHING_TO_INTERRUPT = 11;
	public static final int ERROR_NOT_INTERRUPTIBLE = 12;
	
	/** Constructor
	 */
	public InterruptProcessActionReplica() {
	}
	
	@Override
	public String getActionName() {
		return "Interrupt action execution";
	}
	
	/** Request to interrupt execution
	 * 
	 * Send request to server.
	 * 
	 * @param performer action performer
	 * @param resultHandler result handler
	 */
	public <TExecutor extends IExecutorReplica & IPerformerReplica> void request( TExecutor performer, IActionResultHandler resultHandler )
	{
		((IPerformerReplica) performer).requestAction(
			this,
			resultHandler,
			null
		);
	}
}